# Deindex Unpublished Files

This module provides a way to make files inaccessible when their associated media entities are unpublished.
It can either add a prefix to the file name or move the file to private://unpublishedfiles.
For a full description of the module, visit the
[project page](https://www.drupal.org/project/deindex_unpublished_files).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/deindex_unpublished_files).


## Requirements

Drupal core: 10.2.x or 11.x

A configured private file system (private:// directory must be set in Drupal’s file system settings).

Correct permissions for the private://unpublishedfiles directory (read/write by the web server).


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).



## Configuration

1. clear cache if necessary.
2. Visit the configuration form at **Configuration → Media → Unpublished files settings** (if enabled).
Choose the method used to make unpublished media files inaccessible:
- Add a prefix to the file name.
- Move the file to private://unpublishedfiles.


## Notes for maintainers

- The module stores settings in the config object `deindex_unpublished_files.settings`.
- Ensure you create the `unpublishedfiles` directory inside your private files directory and set correct permissions.ns.

If you modify file access behavior, review integration with other modules handling file access control.

