/**
 * JS library example for 'Demo Button' component.
 *
 * Demonstration of attaching a library to a component: all clicks on the
 * demo button will result in showing JS alert.
 *
 * The Drupal behavior name is generated by: from the javscript filename without
 * `civictheme_` + filename without extension converted to snake case.
 *
 * Be aware that if you have two JS files of the same name in components,
 * one will be overwritten in Drupal.
 *
 * Note that there is no 'Drupal.behaviors' wrapper present - it is added
 * automatically by Webpack during FE assets build, which will produce
 * the following code in dist/scripts.js:
 *
 * @code
 * Drupal.behaviors.civictheme_demo_button = {
 *   attach: function (context, settings) {
 *     if (document.querySelector('[data-component-name="demo-button"]')) {
 *     document.querySelector('[data-component-name="demo-button"]')
 *       .addEventListener('click', () => {
 *         // eslint-disable-next-line no-alert
 *         alert('Triggered example click event for the Demo Button');
 *       });
 *     }
 * }};
 * @endcode
 */
if (document.querySelector('[data-component-name="demo-button"]')) {
  document.querySelector('[data-component-name="demo-button"]').addEventListener('click', () => {
    // eslint-disable-next-line no-alert
    alert('Triggered example click event for the Demo Button');
  });
}
