<?php

declare(strict_types=1);

namespace Drupal\dev_entity_browser\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Returns responses for Developer Entity Browser routes.
 */
final class DevEntityBrowserController extends ControllerBase {

  /**
   * The service that builds the Dev Entity Browser report.
   */
  public function __construct(
    private readonly \Drupal\dev_entity_browser\Service\DevEntityBrowser $devEntityBrowser,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): self {
    return new self(
      $container->get('dev_entity_browser.dev_entity_browser'),
    );
  }

  /**
   * Collect data about the entities, bundles, and fields.
   */
  public function __invoke(): array {
    return $this->devEntityBrowser->buildReport();
  }

}
