# Dev User Cleaner

Dev User Cleaner is a Drupal utility module intended only for development and testing environments.  
It allows administrators to sanitize user accounts by resetting passwords and/or replacing email addresses with safe, dummy values. This helps prevent accidental exposure of real user credentials when databases are shared, cloned, or used for demos.


# This module must NOT be used on production environments.

Running the sanitization process will permanently overwrite user passwords and email addresses.  
Always verify your environment before executing this operation.


# Features

- Reset user passwords to a default value
- Replace user email addresses with dummy addresses
- Excludes the super administrator account (UID 1)
- Simple configuration form in the admin UI
- Prominent warning message before execution


# Installation

1. Download using composer
2. Enable the module
   - Admin UI: Extend/Dev User Cleaner
   - Drush
     drush en dev_user_cleaner


# Configuration & Usage

1. Navigate to the module configuration page (as defined in routing):
    admin/config/people/dev-user-cleaner
2. Choose one or both of the following options:
    Sanitize passwords
    Sanitize emails
3. Click Sanitize Users to execute the operation.
