<?php

declare(strict_types=1);

namespace Drupal\devel_a11y\Hook;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Session\AccountProxyInterface;

/**
 * Hook attachments.
 */
class Attachments {

  public function __construct(
    protected AccountProxyInterface $currentUser,
    protected ConfigFactoryInterface $configFactory,
  ) {}

  /**
   * Implements hook_page_attachments().
   */
  #[Hook('page_attachments')]
  public function pageAttachments(array &$attachments): void {
    $attachments['#cache']['contexts'][] = 'user.permissions';
    if (!$this->currentUser->hasPermission('access devel information')) {
      return;
    }

    $config = $this->configFactory->get('devel_a11y.settings');
    if ($config->get('aural.announce.log')) {
      $attachments['#attached']['library'][] = 'devel_a11y/announce.log';
    }
    if ($config->get('keyboard.tabbingmanager.log')) {
      $attachments['#attached']['library'][] = 'devel_a11y/tabbingmanager.log';
    }
    if ($config->get('keyboard.tabbingmanager.visualize')) {
      $attachments['#attached']['library'][] = 'devel_a11y/tabbingmanager.visualize';
    }
  }

}
