<?php

declare(strict_types=1);

namespace Drupal\devel_a11y\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Devel Accessibility settings for this site.
 */
class Settings extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'devel_a11y_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'devel_a11y.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['aural'] = [
      '#type' => 'details',
      '#title' => $this->t('Aural accessibility (screen readers)'),
      '#tree' => TRUE,
      '#open' => TRUE,
    ];
    $form['aural']['announce']['log'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Log announcements (ARIA live regions)'),
      '#description' => $this->t('Overrides <code>Drupal.announce()</code> to not only announce UI changes via ARIA live regions, but to also log these aural announcements to the browser console.'),
      '#config_target' => 'devel_a11y.settings:aural.announce.log',
    ];

    $form['keyboard'] = [
      '#type' => 'details',
      '#title' => $this->t('Keyboard accessibility'),
      '#tree' => TRUE,
      '#open' => TRUE,
    ];
    $form['keyboard']['tabbingmanager']['log'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Log tabbing manager'),
      '#description' => $this->t('Logs when tabbing is constrained.'),
      '#config_target' => 'devel_a11y.settings:keyboard.tabbingmanager.log',
    ];
    $form['keyboard']['tabbingmanager']['visualize'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Visualize tabbing manager'),
      '#description' => $this->t('Visually indicates which elements are reachable when the tabbing manager is active.'),
      '#config_target' => 'devel_a11y.settings:keyboard.tabbingmanager.visualize',
    ];
    return parent::buildForm($form, $form_state);
  }

}
