<?php

declare(strict_types=1);

namespace Drupal\devel_a11y\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Hook help.
 */
class Help {

  use StringTranslationTrait;

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function helpHook(string $route_name, RouteMatchInterface $route_match): ?string {
    switch ($route_name) {
      case 'help.page.devel_a11y':
        $output = '<p>' . $this->t('Extends the Devel module to simplify testing of accessibility.') . '</p>';
        return $output;
    }
    return NULL;
  }

}
