<?php

declare(strict_types=1);

namespace Drupal\developer_console\StackMiddleware;

use Drupal\developer_console\TimeCounter;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\HttpKernelInterface;

/**
 * Initialization of developer tools.
 */
final class DevInit implements HttpKernelInterface {

  /**
   * Constructor.
   */
  public function __construct(
    protected readonly HttpKernelInterface $httpKernel,
    private readonly TimeCounter $timeCounter,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function handle(Request $request, $type = self::MAIN_REQUEST, $catch = TRUE): Response {
    $this->timeCounter->initialize($request);
    return $this->httpKernel->handle($request, $type, $catch);
  }

}
