# How to Import Arabic Translations for DGA Feedback Module

## Automatic Import (Default Behavior)

**The translations are automatically imported when the module is installed!**

When you install the `dga_feedback` module:
1. If the **Locale module** is enabled
2. And **Arabic language** is configured on your site
3. The Arabic translations from `translations/ar.po` will be **automatically imported**

No manual steps required! ✅

## Manual Import (If Needed)

If for some reason the automatic import didn't work, or you need to re-import translations:

### Method 1: Clear Cache (Auto-Detection)

The translation file is located at:
```
web/modules/custom/dga_feedback/translations/ar.po
```

Drupal should automatically detect this file. To refresh translations:

```bash
# Clear cache
vendor/bin/drush cr

# Or if using ddev:
ddev drush cr
```

### Method 2: Manual Import via Drush

If auto-detection doesn't work, import manually:

```bash
# Import the translation file
# Note: Path is relative to web root (no 'web/' prefix when using drush)
vendor/bin/drush locale:import ar modules/custom/dga_feedback/translations/ar.po --type=customized --override=all

# Or if using ddev:
ddev drush locale:import ar modules/custom/dga_feedback/translations/ar.po --type=customized --override=all
```

**Parameters explained:**
- `ar` - Language code (Arabic)
- `--type=customized` - Marks translations as customized (won't be overwritten by updates)
- `--override=all` - Overwrites existing translations

### Method 3: Import via Drupal Admin UI

1. Go to **Configuration > Regional and language > Translate interface**
2. Click **Import** tab
3. Select **Arabic (ar)** as the language
4. Upload or paste the content of `ar.po` file
5. Click **Import**

## When Translations Are Imported

- ✅ **Automatically on module install** (if Locale module is enabled and Arabic language exists)
- ✅ **Manually via Drush** (if automatic import didn't work)
- ✅ **Manually via Admin UI** (for one-off imports)

## Verify Translation Import

After importing, verify the translations are working:

1. **Check translation status:**
   ```bash
   vendor/bin/drush locale:status
   ```

2. **View translations in admin:**
   - Go to **Configuration > Regional and language > Translate interface**
   - Search for strings like "Was this page useful?" or "DGA Feedback Widget"
   - You should see Arabic translations

3. **Test on frontend:**
   - Switch your site language to Arabic
   - Visit a page with the feedback widget
   - Verify all text appears in Arabic

## Update Deployment Script

If you want to automatically import this translation during deployment, add this to your `cicd/deploy/deploy.sh`:

```bash
# Import module-specific translations
/var/www/localhost/htdocs/vendor/bin/drush locale:import ar web/modules/custom/dga_feedback/translations/ar.po --type=customized --override=all
```

## Troubleshooting

**Translations not showing?**
1. Clear cache: `drush cr`
2. Rebuild translations: `drush locale:update`
3. Check that Arabic language is enabled in your site
4. Verify the file path is correct

**Need to update translations?**
1. Edit `web/modules/custom/dga_feedback/translations/ar.po`
2. Re-import using Method 2 or clear cache (Method 1)

