# DGA Feedback Module

The feedback page is designed to gather user insights. It includes a brief introduction encouraging feedback, followed by sections for rating, comments, and suggestions. Clear prompts guide users to share their opinions, making the process simple and inviting.

## Features

- **Yes/No Feedback Widget**: Simple binary feedback system (Was this page useful?)
- **Reasons Selection**: Multiple reasons checkboxes for both Yes and No responses
- **Optional Feedback Text**: Free-form textarea for additional comments
- **Demographic Data**: Optional gender selection
- **Live Statistics**: Real-time display of feedback statistics (percentage and count)
- **Admin Interface**: Complete admin interface for viewing, editing, and managing submissions
- **Configurable Text**: All UI text can be customized through the admin settings
- **DGA Design System Compliant**: Follows Saudi DGA Design Guidelines
- **Accessible**: Built with accessibility in mind

## Installation

1. Place the module in `web/modules/custom/dga_feedback/`
2. Enable the module via Drush: `drush en dga_feedback`
3. Or enable via the Drupal admin interface: Extend > Custom > DGA Feedback

## Configuration

### Widget Settings

Navigate to: **Admin > Content > DGA Feedback Submissions > Settings**

Configure:
- Question text (e.g., "Was this page useful?")
- Button labels (Yes/No)
- Statistics text template
- Reasons options (separate lists for Yes and No)
- Form labels and placeholders
- Gender options
- Success messages

### Block Placement

1. Go to **Structure > Block layout**
2. Add the "DGA Feedback Widget" block to your desired region
3. Configure visibility settings as needed

## Usage

### Frontend Widget

The widget displays:
- **Closed State**: Question with Yes/No buttons and statistics summary
- **Open State**: Full form with reasons, feedback textarea, and gender selection
- **Submitted State**: Confirmation message with updated statistics

### Admin Interface

Navigate to **Admin > Content > DGA Feedback Submissions** to:
- View all submissions with filters and pagination
- Edit individual submissions
- Delete single or bulk submissions
- View overall statistics and distribution

### API Endpoints

- `POST /dga-feedback/submit` - Submit feedback
- `GET /dga-feedback/stats` - Get statistics for a URL or entity

## Database Schema

The module creates a `dga_feedback` table with:
- `id`: Primary key
- `entity_type`: Entity type (e.g., 'node')
- `entity_id`: Entity ID
- `is_useful`: 'yes' or 'no'
- `reasons`: JSON array of selected reasons
- `feedback`: Optional feedback text
- `gender`: Optional gender ('male' or 'female')
- `url`: URL where feedback was submitted
- `user_id`: User ID (NULL for anonymous)
- `ip_address`: IP address
- `created`: Unix timestamp

## Development

### File Structure

```
dga_feedback/
├── config/
│   ├── install/
│   │   └── dga_feedback.settings.yml
│   └── schema/
│       └── dga_feedback.schema.yml
├── css/
│   ├── feedback.css
│   └── admin.css
├── js/
│   ├── feedback.js
│   └── admin.js
├── src/
│   ├── Controller/
│   │   ├── DgaFeedbackController.php
│   │   └── DgaFeedbackAdminController.php
│   ├── Form/
│   │   ├── DgaFeedbackSettingsForm.php
│   │   ├── DgaFeedbackEditForm.php
│   │   └── DgaFeedbackDeleteForm.php
│   ├── Plugin/
│   │   └── Block/
│   │       └── DgaFeedbackBlock.php
│   └── Service/
│       └── DgaFeedbackService.php
├── templates/
│   ├── dga-feedback-widget.html.twig
│   └── feedback-admin.html.twig
├── dga_feedback.info.yml
├── dga_feedback.module
├── dga_feedback.install
├── dga_feedback.libraries.yml
├── dga_feedback.links.menu.yml
├── dga_feedback.routing.yml
├── dga_feedback.services.yml
├── composer.json
└── README.md
```

## Requirements

- Drupal 10 or 11
- PHP 8.1 or higher
