<?php

namespace Drupal\dga_feedback\Plugin\Menu;

use Drupal\Core\Menu\MenuLinkDefault;

/**
 * Custom menu link plugin for the Translations menu item.
 */
class DgaFeedbackTranslationsMenuLink extends MenuLinkDefault {

  /**
   * {@inheritdoc}
   */
  public function getTitle() {
    $config = \Drupal::config('dga_feedback.settings');
    $language_manager = \Drupal::languageManager();
    $current_lang = $language_manager->getCurrentLanguage()->getId();
    $is_arabic = ($current_lang === 'ar');

    if ($is_arabic) {
      $title = $config->get('menu_title_translations_ar');
      if (!empty($title)) {
        return $title;
      }
      $title = $config->get('menu_title_translations_en');
      if (!empty($title)) {
        return $title;
      }
      return 'الترجمات';
    }

    $title = $config->get('menu_title_translations_en');
    if (!empty($title)) {
      return $title;
    }
    return 'Translations';
  }

}

