<?php

namespace Drupal\dga_feedback\Plugin\Menu\LocalTask;

use Drupal\Core\Menu\LocalTaskDefault;
use Symfony\Component\HttpFoundation\Request;

/**
 * Local task plugin for Translations tab with config-based translation.
 */
class DgaFeedbackTranslationsTask extends LocalTaskDefault {

  /**
   * {@inheritdoc}
   */
  public function getTitle(?Request $request = NULL) {
    $config = \Drupal::config('dga_feedback.settings');
    $language_manager = \Drupal::languageManager();
    $current_lang = $language_manager->getCurrentLanguage()->getId();
    $is_arabic = ($current_lang === 'ar');

    if ($is_arabic) {
      $title = $config->get('menu_title_translations_ar');
      if (!empty($title)) {
        return $title;
      }
      $title = $config->get('menu_title_translations_en');
      if (!empty($title)) {
        return $title;
      }
      return 'الترجمات';
    }

    $title = $config->get('menu_title_translations_en');
    if (!empty($title)) {
      return $title;
    }
    return 'Translations';
  }

}

