# Changelog

All notable changes to the DGA Feedback module will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [2.0.0] - 2025-01-XX

### Major Release - UI-Based Translations & Enhanced UX

This release introduces a complete UI-based translation system, inline validation, auto-refresh functionality, and significant UX improvements. The module now matches the feature set and code patterns of `dga_rating` 2.2.0.

### Added

- **UI-Based Translation System**
  - New bilingual translation form (`/admin/content/dga-feedback/translations`)
  - Managed English & Arabic strings for closed state, form text, submitted state, validation, API messages, and admin menu items
  - Removed dependency on `.po` files (translations directory deleted)
  - Validation messages section now open by default for better visibility
- **Custom Admin Navigation**
  - Hierarchical menu: DGA Feedback → Feedback Dashboard, Settings, Translations
  - Toolbar SVG icon and consistent sidebar classes (`toolbar-icon--dga-feedback`)
  - Config-driven titles with fallback defaults for English & Arabic
- **Inline Validation Enhancements**
  - Configurable inline error messages for Yes/No selection, reasons, feedback text, gender, and generic failures
  - JavaScript now surfaces validation inline (red text under fields, matching `dga_rating` module)
  - Error messages clear automatically when user corrects the field
- **Auto Refresh + Configurable Delay**
  - Widget refreshes automatically after successful submission (default 3 seconds, configurable in settings)
  - New AJAX endpoint (`/dga-feedback/refresh-block`) to update statistics without reloading the page
  - State resets to closed view, ready for the next submission

### Changed

- **Settings Form**
  - Now focuses on widget behaviour (refresh delay) and security controls (rate limiting, length limits)
  - All text customization migrated to the Translations form
  - Reasons instruction field no longer includes parentheses (added automatically by template)
- **Front-End Widget**
  - Uses config-based translations for all strings (question, buttons, reasons, etc.)
  - Inline messages read from configuration and support RTL layouts
  - Removed `required` HTML attributes from form fields (validation handled in JavaScript)
- **Menu & Local Tasks**
  - Local tasks (tabs) now honour translated titles
  - Parent menu item removed from primary tabs to avoid duplication

### Fixed

- **Submit Button Functionality**
  - Fixed scope issues preventing success handler from executing
  - Success state now properly displays and widget refreshes correctly
  - All form elements properly queried from widget scope
- **Error Message Display**
  - Fixed inline error messages not displaying (CSS classes now properly applied)
  - Error messages now show as red text under fields, matching `dga_rating` module
  - Error styling clears when user corrects the field
- **Form Validation**
  - Fixed validation not triggering on empty form submission
  - All validation checks now work correctly with proper error display
- **Translation Persistence**
  - Properly persisted Arabic translations for nested configuration values (`#tree` handling)
- **Menu Preprocessing**
  - Graceful handling of menu preprocessing when encountering external URLs (no exceptions)
- **Local Task Plugins**
  - Fatal errors resolved for local task plugins (method signatures match core expectations)

### Technical Details

- Added new config schema entries for `_en` / `_ar` string fields, validation messages, API responses, menu titles, and `refresh_delay`
- Added menu link & local task plugin classes for dynamic translation lookups
- Introduced `css/menu-icon.css` and `toolbar_icon` library for toolbar styling
- Updated JavaScript to consume `drupalSettings.dgaFeedback` (submit URL, stats URL, refresh URL, validation messages, refresh delay)
- Submit handler now uses `btn.onclick` pattern matching `dga_rating` module for consistency
- All widget state management properly scoped to avoid closure issues

### Migration Notes

- **Upgrading from 1.0.2 or earlier**: This is a major version release (2.0.0). Existing installations will receive default bilingual values on update (`hook_install()` ensures missing keys are populated)
- Run database updates or re-save configuration if deploying via config sync
- Remove any custom `.po` workflow; translations are now managed via configuration export/import
- Visit **DGA Feedback → Translations** after upgrade to review and customize translation values
- The Settings form has been refactored - widget text customization is now in the Translations form

## [1.0.2] - Previous Release

See [Drupal.org project page](https://www.drupal.org/project/dga_feedback) for details.

## [1.0.1] - Previous Release

See [Drupal.org project page](https://www.drupal.org/project/dga_feedback) for details.

## [1.0.0] - Initial Release

- Binary (Yes/No) feedback widget with reasons, optional comments, and gender selection
- Admin submissions dashboard with statistics, filters, and CRUD operations
- Basic configurable text via settings form (English only)
- `.po` file-based translations for Arabic
