# DGA Feedback Module

The feedback page is designed to gather user insights. It includes a brief introduction encouraging feedback, followed by sections for rating, comments, and suggestions. Clear prompts guide users to share their opinions, making the process simple and inviting.

## Features

- **Yes/No Feedback Widget**: Simple binary feedback system (Was this page useful?)
- **Reason Selection**: Dedicated reason lists for both Yes and No responses (multi-select)
- **Optional Feedback Text**: Free-form textarea for additional comments
- **Demographic Data**: Optional gender selection
- **Live Statistics**: Real-time display of feedback (percentage + total count)
- **UI-Based Translations**: Manage all English & Arabic strings via the admin UI (no `.po` files)
- **Inline Validation**: Friendly inline error messages for each required field
- **Auto Refresh**: Widget resets automatically after submission (configurable delay)
- **Custom Admin Navigation**: DGA Feedback → Feedback Dashboard, Settings, Translations (SVG icon in toolbar)
- **Admin Dashboard**: Full submissions dashboard with filters, bulk actions, and statistics
- **DGA Design System Compliant & Accessible**

## Installation

1. Place the module in `web/modules/custom/dga_feedback/`
2. Enable the module via Drush: `drush en dga_feedback`
3. Or enable via the Drupal admin interface: Extend > Custom > DGA Feedback

## Configuration

### Menu Structure

- **DGA Feedback** (main menu with custom SVG icon)
  - **Feedback Dashboard** – View submissions and statistics
  - **Settings** – Configure widget behavior, rate limiting, and refresh delay
  - **Translations** – Manage English & Arabic text for the widget, validation, and menu items

### Configure Translations

1. Navigate to **DGA Feedback > Translations** (`/admin/content/dga-feedback/translations`)
2. Each section provides bilingual (EN/AR) fields displayed side-by-side:
   - **Closed State**: Question text, Yes/No buttons, statistics template
   - **Feedback Form**: Close button, reasons title, reasons instruction, reason lists (multi-line input for Yes / No), feedback label/placeholder, gender labels
   - **Submitted State**: Success message
   - **Validation Messages**: All error messages (Yes/No required, reason required, feedback required, gender required, submission failed, unknown error)
   - **API & Backend Messages**: Method not allowed, invalid JSON, rate limit, save failed, success message
   - **Menu Items**: DGA Feedback, Feedback Dashboard, Settings, Translations titles
3. **Note**: Reasons instruction field should not include parentheses (they are added automatically by the template)
4. Save to apply instantly (no cache clear required)

### Configure Widget Behavior

1. Navigate to **DGA Feedback > Settings** (`/admin/config/dga-feedback/settings`)
2. Configure:
   - Widget refresh delay (seconds) after successful submission
   - Rate limiting (maximum submissions per IP + time window)
   - Feedback length constraints and reason length/count limits
3. Save configuration

### Block Placement

1. Go to **Structure > Block layout**
2. Add the "DGA Feedback Widget" block to your desired region
3. Configure visibility settings as needed

## Usage

### Frontend Widget

The widget displays:
- **Closed State**: Question with Yes/No buttons and statistics summary
- **Open State**: Full form with reasons, feedback textarea, and gender selection
- **Inline Validation**: Required fields show inline red error messages (red text under each field) if missing
  - Yes/No selection required
  - At least one reason must be selected
  - Feedback text is required
  - Gender selection is required
- **Submitted State**: Success message displayed, followed by automatic widget refresh after configurable delay (returns to closed state, updates statistics)

### Validation Behavior

- All validation errors display as red text under the relevant field label
- Error messages are fully translatable via the Translations form
- Errors automatically clear when the user corrects the field
- Form does not submit until all required fields are filled

### Admin Interface

Navigate to **Admin > Content > DGA Feedback** to:
- View all submissions with filters and pagination
- Edit individual submissions
- Delete single or bulk submissions
- View overall statistics and distribution

### API Endpoints

- `POST /dga-feedback/submit` - Submit feedback
- `GET /dga-feedback/stats` - Get statistics for a URL or entity
- `GET /dga-feedback/refresh-block` - Refresh widget statistics (used by auto-refresh)

## Database Schema

The module creates a `dga_feedback` table with:
- `id`: Primary key
- `entity_type`: Entity type (e.g., 'node')
- `entity_id`: Entity ID
- `is_useful`: 'yes' or 'no'
- `reasons`: JSON array of selected reasons
- `feedback`: Optional feedback text
- `gender`: Optional gender ('male' or 'female')
- `url`: URL where feedback was submitted
- `user_id`: User ID (NULL for anonymous)
- `ip_address`: IP address
- `created`: Unix timestamp

## Development

### File Structure

```
dga_feedback/
├── config/
│   ├── install/
│   │   └── dga_feedback.settings.yml
│   └── schema/
│       └── dga_feedback.schema.yml
├── css/
│   ├── admin-menu-fix.css
│   ├── admin.css
│   ├── feedback.css
│   └── menu-icon.css
├── js/
│   ├── feedback.js
│   └── admin.js
├── src/
│   ├── Controller/
│   │   ├── DgaFeedbackController.php
│   │   └── DgaFeedbackAdminController.php
│   ├── Form/
│   │   ├── DgaFeedbackDeleteForm.php
│   │   ├── DgaFeedbackEditForm.php
│   │   ├── DgaFeedbackSettingsForm.php
│   │   └── FeedbackTranslationForm.php
│   ├── Plugin/
│   │   ├── Block/
│   │   │   └── DgaFeedbackBlock.php
│   │   ├── Menu/
│   │   │   ├── DgaFeedbackMenuLink.php
│   │   │   ├── DgaFeedbackDashboardMenuLink.php
│   │   │   ├── DgaFeedbackSettingsMenuLink.php
│   │   │   └── DgaFeedbackTranslationsMenuLink.php
│   │   │   └── LocalTask/
│   │   │       ├── DgaFeedbackDashboardTask.php
│   │   │       ├── DgaFeedbackSettingsTask.php
│   │   │       └── DgaFeedbackTranslationsTask.php
│   └── Service/
│       └── DgaFeedbackService.php
├── templates/
│   ├── dga-feedback-widget.html.twig
│   └── feedback-admin.html.twig
├── dga_feedback.info.yml
├── dga_feedback.module
├── dga_feedback.install
├── dga_feedback.libraries.yml
├── dga_feedback.links.menu.yml
├── dga_feedback.routing.yml
├── dga_feedback.services.yml
├── composer.json
└── README.md
```

## Requirements

- Drupal 10.x or 11.x
- PHP 8.1 or higher
- MySQL 5.7+ / MariaDB 10.3+ / PostgreSQL 10+ / SQLite 3.26+

## Version History

- **2.0.0** (Current) - UI-based translations, inline validation, auto-refresh, custom menu structure
- **1.0.2** - Previous release (see [Drupal.org](https://www.drupal.org/project/dga_feedback))
- **1.0.1** - Previous release
- **1.0.0** - Initial release

## Upgrade Notes

When upgrading from 1.0.2 or earlier to 2.0.0:
- Run `drush updb` and `drush cr` after updating
- Visit **DGA Feedback → Translations** to review new translation options
- Remove any custom `.po` file workflow (translations now managed via UI)
- See `CHANGELOG.md` and `RELEASE_NOTES.md` for detailed upgrade instructions

## License

GPL-2.0-or-later

## Support & Contributing

- **Drupal.org Project**: [dga_feedback](https://www.drupal.org/project/dga_feedback)
- **Issue Queue**: Report bugs and feature requests on [Drupal.org issue queue](https://www.drupal.org/project/issues/dga_feedback)
- **Documentation**: See `README.md`, `CHANGELOG.md`, and `RELEASE_NOTES.md`
- **Design Guidelines**: [DGA Design System - Feedback Section](https://design.dga.gov.sa/guidelines/templates/feedback-section)
