# Release Notes for DGA Feedback 2.0.0

## 🚀 Overview

DGA Feedback 2.0.0 focuses on multilingual flexibility, inline validation, and a streamlined administrator experience. The release removes `.po` file dependencies, introduces a dedicated translations tab, and adds an auto-refresh workflow that keeps the widget ready for the next submission. This release includes critical bug fixes for submit button functionality and error message display, ensuring a smooth user experience.

---

## ✨ What’s New

### 🌐 UI-Based Translation System
- New translation form at **DGA Feedback → Translations** (`/admin/content/dga-feedback/translations`)
- Manage English & Arabic strings for:
  - Closed/Open/Submitted widget states
  - Yes/No reason lists (multi-line inputs)
  - Inline validation + API response messages
  - Admin menu items (DGA Feedback, Feedback Dashboard, Settings, Translations)
- `.po` files have been removed; translations now live in configuration (export/import friendly)

### 🧭 Refreshed Admin Navigation
- Hierarchical menu: **DGA Feedback** (toolbar icon) → **Feedback Dashboard**, **Settings**, **Translations**
- Local tasks/tabs honour translated titles and avoid duplicate “DGA Feedback” tabs
- Custom menu & local-task plugins load config-driven titles with graceful fallbacks

### ✅ Inline Validation & UX Improvements
- Inline error messages for Yes/No selection, reasons, feedback text, and gender
- Error messages display as red text under each field (matching `dga_rating` module)
- Validation messages are fully configurable & translatable via Translations form
- Errors automatically clear when user corrects the field
- JavaScript uses `drupalSettings.dgaFeedback` for URLs, messages, and refresh delay
- Validation messages section now open by default in Translations form for better visibility

### 🔄 Auto Refresh + Configurable Delay
- Widget returns to the closed state automatically after successful submission
- Statistics refresh via new AJAX endpoint `GET /dga-feedback/refresh-block`
- Refresh delay is configurable (default 3 seconds) under **DGA Feedback → Settings**

---

## ⚙️ Configuration Updates

### Translations Tab
1. Navigate to **DGA Feedback → Translations**
2. Update bilingual fields (English/Arabic) across closed state, form text, submitted state, validation, API messages, and menu titles
3. Save to apply immediately (no cache clear required)

### Settings Tab
- Now focused on behaviour & security:
  - Widget refresh delay (seconds — stored as milliseconds)
  - Rate limiting (maximum submissions per IP + time window)
  - Feedback/reason length and count limits
- All widget text moved to the translations form to avoid duplication
- **Note**: Reasons instruction field no longer includes parentheses in default values (parentheses are added automatically by the template)

---

## 🔧 Technical Highlights

- Added bilingual config keys (`*_en`, `*_ar`) for all UI/validation/menu strings
- New menu & local-task plugin classes for translated titles
- Added `css/menu-icon.css` + `toolbar_icon` library for toolbar styling
- JavaScript now relies on configuration-driven messages and refresh delay
- Controller returns translated messages (no hardcoded English)

---

## 📦 Upgrade Checklist

**Upgrading from 1.0.2 or earlier:**

1. **Backup your site** (database and files)
2. Update the module code to v2.0.0 (replace the old version)
3. Run database updates: `drush updb`
4. Clear caches: `drush cr`
5. Visit **DGA Feedback → Translations** and verify default values (all sections now open by default)
6. Review **DGA Feedback → Settings** to confirm refresh delay & rate limit values
7. If using configuration sync: export configuration to capture new defaults (`drush cex`)
8. **Important**: Remove any custom `.po` file workflow - translations are now managed via the Translations form

---

## 🐛 Bug Fixes

- **Submit Button**: Fixed scope issues preventing success handler from executing properly
- **Error Messages**: Fixed inline error messages not displaying (CSS classes now properly applied)
- **Form Validation**: Fixed validation not triggering on empty form submission
- **Translation Persistence**: Fixed Arabic translations not saving in nested configuration values
- **Menu Preprocessing**: Fixed errors when encountering external URLs in menu preprocessing
- **Local Task Plugins**: Fixed fatal errors with method signature mismatches

## 🧪 Testing Recommendations

- Submit feedback as anonymous & authenticated users
- Test submit button with all fields filled (should show success and auto-refresh)
- Trigger validation errors (Yes/No, reasons, feedback text, gender) - should show red text under fields
- Verify errors clear when user corrects the field
- Confirm success state auto-refreshes and statistics update
- Switch language to Arabic and verify widget + menu titles
- Confirm dashboard filters, bulk actions, and statistics still function
- Test that submissions are recorded in backend even if widget UI has issues

---

## 📚 Resources

- **Documentation**: `README.md`
- **Change Log**: `CHANGELOG.md`
- **Design System**: [DGA Design System – Feedback Section](https://design.dga.gov.sa/guidelines/templates/feedback-section)

---

Thank you for using DGA Feedback! This release delivers a faster, translation-friendly workflow that keeps the widget ready for the next submission—no manual resets, no `.po` files, and a cleaner admin experience.
# Release Notes for DGA Feedback 1.0.0

## 🎉 Initial Release: Comprehensive Feedback Collection System

DGA Feedback is a powerful, accessible feedback collection module designed to gather user insights through a simple, intuitive widget. This initial release provides a complete feedback management system with advanced statistics, flexible configuration, and full compliance with the Saudi DGA Design Guidelines.

---

## ✨ Key Features

### 📝 Simple Binary Feedback System
- **Yes/No Question**: Simple "Was this page useful?" binary feedback system
- **Instant Statistics**: Real-time display of feedback percentage and total count
- **Three-State Widget**:
  - **Closed State**: Question with Yes/No buttons and statistics summary
  - **Open State**: Full form with reasons, feedback text, and demographic options
  - **Submitted State**: Confirmation message with updated statistics

### ✅ Reasons Selection
- **Multiple Reasons**: Users can select multiple reasons for their feedback
- **Separate Lists**: Different reason options for "Yes" and "No" responses
- **Checkbox Interface**: Clear, accessible checkbox selection for each reason
- **Configurable Options**: All reasons can be customized through admin settings
- **Default Reasons Include**:
  - **For Yes**: "Content is relevant", "It was well written", "The layout made it easy to read", "Something else"
  - **For No**: "Content is not relevant", "Content is not accurate", "Content is too long", "Something else"

### 💬 Optional Feedback Text
- **Free-Form Comments**: Users can provide additional written feedback
- **Configurable Length**: Maximum feedback text length customizable (default: 5000 characters)
- **Sanitized Input**: All user input is sanitized for security
- **Required Field**: Can be configured as required or optional

### 👥 Demographic Data Collection
- **Gender Selection**: Optional gender selection (Male/Female)
- **Customizable Labels**: Gender option labels can be customized
- **Privacy-Focused**: Optional demographic data collection

### 📊 Advanced Statistics Dashboard
- **Comprehensive Statistics Blocks** with visual indicators:
  - Total Submissions with trend indicator (shows last 7 days activity)
  - Useful Percentage with progress bar visualization
  - Total Pages and Average per Page metrics
  - Yes/No Response distribution with gauge bars
  - Recent Activity statistics (last 7 days count and percentage)
  - **Most Useful Page** block showing highest useful percentage page with clickable URL
  - **Most Feedback Page** block showing page with most submissions
  - **User Type Breakdown** (Anonymous vs Authenticated) with mini bar chart

### 🔧 Operations & Management
- **Operations Column** with split button design:
  - Primary "Edit" action button
  - Dropdown toggle for additional actions
  - "Delete" action in secondary dropdown menu
  - Matches Drupal core content admin table style
- **Bulk Operations**:
  - "Select All" checkbox in table header
  - Individual checkboxes for each submission
  - Bulk operations bar showing selected count
  - Bulk delete action with CSRF protection

### ⚙️ Configuration & Customization
- **Complete Text Customization**:
  - Admin settings form to configure all frontend widget text
  - Configurable question text, button labels, statistics template
  - Editable reasons lists (separate for Yes and No)
  - Customizable form labels and placeholders
  - Configurable gender options
  - Customizable success messages
  - Settings accessible via `/admin/content/dga-feedback/settings`
  - All changes cached and invalidated automatically
- **Collapsible Settings Sections**:
  - Closed State settings (expanded by default)
  - Feedback Form settings (expanded by default)
  - Submitted State settings (collapsed by default)
  - Security & Limits settings (collapsed by default)

### 🔒 Security Features
- **Input Sanitization**: All user input is sanitized using `strip_tags()` and length limits
- **Configurable Rate Limiting**: 
  - Maximum submissions per IP address (default: 20 per hour)
  - Configurable time window (default: 3600 seconds)
  - Can be disabled by setting limit to 0
- **Input Length Limits** (all configurable):
  - Maximum feedback text length (default: 5000 characters)
  - Maximum length per reason (default: 200 characters)
  - Maximum number of reasons allowed (default: 10)
- **XSS Prevention**: All user-generated content is escaped in templates
- **CSRF Protection**: Bulk operations protected with CSRF tokens

### 📈 Data Analysis
- **URL-Based Statistics**:
  - Statistics grouped by page/URL
  - Sortable by count, useful percentage, or URL
  - Most useful page identification
  - Most feedback page identification
- **Recent Activity Tracking**:
  - Last 7 days submission count and useful percentage
  - Last 30 days statistics available
- **User Type Analysis**:
  - Breakdown of submissions by anonymous vs authenticated users
  - Visual mini bar chart representation
- **Usefulness Distribution**:
  - Visual breakdown of Yes vs No responses
  - Percentage calculations with gauge bars

### 🎨 User Interface Improvements
- **Enhanced Table Design**:
  - Matches Drupal core content admin table appearance
  - Sticky table header support
  - Better visual hierarchy and sort indicators
  - Sortable columns (ID, Useful, URL, User, Date)
- **Collapsible Sections**:
  - Collapsible Filters & Search section with toggle button
  - Smooth animations for expand/collapse
- **Responsive Design**: Works seamlessly on desktop and mobile devices
- **Accessibility**: Built with ARIA labels, keyboard navigation, and screen reader support

### 🌐 AJAX-Powered
- **Asynchronous Submission**: All feedback submissions use AJAX (no page reload)
- **Real-Time Statistics**: Statistics update immediately after submission
- **Smooth User Experience**: No page refresh required for feedback submission
- **Anonymous User Support**: Full AJAX support for anonymous users with proper fallback handling

### 🔍 Advanced Filtering & Search
- **Multiple Filter Options**:
  - Filter by URL
  - Filter by Useful status (Yes/No)
  - Filter by Entity Type
  - Filter by Entity ID
  - Filter by Date Range (From/To)
- **Sortable Columns**: Click column headers to sort submissions
- **Pagination**: Efficient pagination for large datasets (50 items per page)

---

## 🎯 Use Cases

### Government Websites
- Collect feedback on service pages
- Gather insights on content usefulness
- Understand user satisfaction with digital services

### Content Management
- Measure content effectiveness
- Identify pages needing improvement
- Track user engagement metrics

### Service Improvement
- Collect structured feedback with reasons
- Analyze demographic trends
- Identify most and least useful content

---

## 📋 Technical Details

### Database Schema
The module creates a `dga_feedback` table with the following fields:
- `id`: Primary key (serial)
- `entity_type`: Entity type (e.g., 'node')
- `entity_id`: Entity ID
- `is_useful`: 'yes' or 'no'
- `reasons`: JSON array of selected reasons
- `feedback`: Optional feedback text
- `gender`: Optional gender ('male' or 'female')
- `url`: URL where feedback was submitted
- `user_id`: User ID (NULL for anonymous)
- `ip_address`: IP address for rate limiting
- `created`: Unix timestamp

### Service Methods
- `saveFeedback()`: Saves feedback submission with sanitization
- `getStatistics()`: Gets statistics for a specific URL or entity
- `getStatisticsGroupedByUrl()`: Gets statistics grouped by URL
- `getOverallStatistics()`: Gets overall system-wide statistics
- `getUsefulnessDistribution()`: Gets Yes/No distribution
- `getRecentActivity()`: Returns statistics for last 7 and 30 days
- `getMostUsefulPage()`: Returns page with highest useful percentage
- `getMostFeedbackPage()`: Returns page with most submissions
- `getSubmissionsByUserType()`: Returns breakdown by anonymous vs authenticated users
- `getAllSubmissions()`: Retrieves all submissions with filtering and pagination
- `bulkDeleteSubmissions()`: Deletes multiple submissions at once
- `updateSubmission()`: Updates an existing submission
- `deleteSubmission()`: Deletes a single submission

### API Endpoints
- `POST /dga-feedback/submit`: Submit feedback (returns JSON)
- `GET /dga-feedback/stats`: Get statistics for a URL or entity (returns JSON)

### Forms & Routes
- `DgaFeedbackSettingsForm`: Configuration form for widget text and security settings
- `DgaFeedbackEditForm`: Form for editing individual submissions
- `DgaFeedbackDeleteForm`: Confirmation form for deleting submissions
- Routes: `/admin/content/dga-feedback`, `/admin/content/dga-feedback/settings`, edit, delete, bulk operations

### Dependencies
- `core/dropbutton`: For Operations dropdown in admin table
- `core/toolbar`: For admin menu integration

---

## 🔄 Installation & Setup

### For New Installations

1. **Download and Install**:
   ```bash
   # Place module in web/modules/custom/dga_feedback/
   drush en dga_feedback
   ```

2. **Clear Cache**:
   ```bash
   drush cr
   ```

3. **Place Block**:
   - Go to **Structure > Block layout**
   - Add "DGA Feedback Widget" block to desired region
   - Configure visibility settings

4. **Configure Settings** (Optional):
   - Navigate to **Admin > Content > Feedback Submissions > Settings**
   - Customize widget text, reasons, and security settings
   - Save configuration

---

## ⚠️ Requirements

- **Drupal**: 10.x or 11.x
- **PHP**: 8.1 or higher
- **Database**: MySQL 5.7+, MariaDB 10.3+, PostgreSQL 10+, or SQLite 3.26+

---

## 🌍 Translation Support

- All UI strings are translatable using `$this->t()` or `|t` filter in Twig
- JavaScript strings wrapped with `Drupal.t()`
- All configurable frontend text is translatable
- Ready for localization

---

## 🎨 Design System Compliance

This module is fully compliant with the **Saudi DGA Design Guidelines**:
- Follows [DGA Design System - Feedback Section](https://design.dga.gov.sa/guidelines/templates/feedback-section)
- Accessible design patterns
- Responsive layout
- Consistent with DGA design principles

---

## 🔗 Links

- **Design Guidelines**: [DGA Design System - Feedback Section](https://design.dga.gov.sa/guidelines/templates/feedback-section)
- **Documentation**: See `README.md` in module directory
- **Issue Queue**: Report bugs and feature requests on Drupal.org

---

## 📚 Documentation

- **Full Documentation**: See `README.md` for complete usage guide
- **API Documentation**: Inline code documentation for developers
- **Configuration Schema**: See `config/schema/dga_feedback.schema.yml`

---

## 🛠️ Development

### Code Quality
- **PSR Standards**: Follows PSR coding standards
- **Type Safety**: Proper type hints and validation
- **Error Handling**: Comprehensive error handling and logging
- **Security**: Input sanitization, XSS prevention, CSRF protection
- **Performance**: Optimized database queries and cache invalidation

### Testing Recommendations
1. Test feedback submission for both anonymous and authenticated users
2. Verify rate limiting works correctly
3. Test bulk operations functionality
4. Verify statistics calculations are accurate
5. Test all filter and sort options
6. Verify accessibility with screen readers

---

## 🙏 Acknowledgments

Thank you for using DGA Feedback! This module is designed to help government websites and organizations collect valuable user feedback while maintaining accessibility, security, and compliance with design standards.

---

## 📝 Release Information

**Version**: 2.0.0  
**Release Date**: January 2025  
**Previous Version**: 1.0.2  
**Maintainer**: Ahmed Eid Abdelrahim  
**Drupal Version**: 10.x, 11.x  
**PHP Version**: 8.1+  
**License**: GPL-2.0-or-later

**Drupal.org Project**: [dga_feedback](https://www.drupal.org/project/dga_feedback)

---

## 🚀 What's Next

Future versions may include:
- Export functionality (CSV, Excel)
- Advanced analytics and reporting
- Email notifications for administrators
- Integration with other DGA modules
- Additional chart visualizations
- API enhancements

---

**Get Started**: Enable the module, place the block, and start collecting valuable user feedback today!

