<?php

namespace Drupal\dga_feedback\Plugin\Menu;

use Drupal\Core\Menu\MenuLinkDefault;

/**
 * Custom menu link plugin for DGA Feedback with icon support.
 */
class DgaFeedbackMenuLink extends MenuLinkDefault {

  /**
   * {@inheritdoc}
   */
  public function getTitle() {
    $config = \Drupal::config('dga_feedback.settings');
    $language_manager = \Drupal::languageManager();
    $current_lang = $language_manager->getCurrentLanguage()->getId();
    $is_arabic = ($current_lang === 'ar');

    if ($is_arabic) {
      $title = $config->get('menu_title_dga_feedback_ar');
      if (!empty($title)) {
        return $title;
      }
      $title = $config->get('menu_title_dga_feedback_en');
      if (!empty($title)) {
        return $title;
      }
      return 'تعليقات DGA';
    }

    $title = $config->get('menu_title_dga_feedback_en');
    if (!empty($title)) {
      return $title;
    }
    return 'DGA Feedback';
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return 'DGA Feedback administration';
  }

  /**
   * {@inheritdoc}
   */
  public function getOptions() {
    $options = parent::getOptions();

    if (!isset($options['attributes'])) {
      $options['attributes'] = [];
    }
    if (!isset($options['attributes']['class'])) {
      $options['attributes']['class'] = [];
    }
    if (!in_array('toolbar-icon--dga-feedback', $options['attributes']['class'])) {
      $options['attributes']['class'][] = 'toolbar-icon--dga-feedback';
    }
    $options['attributes']['data-icon'] = 'dga-feedback';

    return $options;
  }

}

