<?php

namespace Drupal\dga_feedback\Plugin\Menu;

use Drupal\Core\Menu\MenuLinkDefault;

/**
 * Custom menu link plugin for the Settings menu item.
 */
class DgaFeedbackSettingsMenuLink extends MenuLinkDefault {

  /**
   * {@inheritdoc}
   */
  public function getTitle() {
    $config = \Drupal::config('dga_feedback.settings');
    $language_manager = \Drupal::languageManager();
    $current_lang = $language_manager->getCurrentLanguage()->getId();
    $is_arabic = ($current_lang === 'ar');

    if ($is_arabic) {
      $title = $config->get('menu_title_settings_ar');
      if (!empty($title)) {
        return $title;
      }
      $title = $config->get('menu_title_settings_en');
      if (!empty($title)) {
        return $title;
      }
      return 'الإعدادات';
    }

    $title = $config->get('menu_title_settings_en');
    if (!empty($title)) {
      return $title;
    }
    return 'Settings';
  }

}

