# Release Notes for DGA Rating 2.0.0

## 🎉 Major Release: Enhanced Admin Dashboard & Advanced Features

This release introduces a comprehensive admin dashboard overhaul with advanced statistics, bulk operations, and extensive configuration options.

---

## ✨ New Features

### 📊 Advanced Statistics Dashboard
- **Comprehensive Statistics Blocks** with visual indicators:
  - Total Submissions with trend indicator (shows last 7 days activity)
  - Average Rating with progress bar visualization
  - Total Pages and Average per Page metrics
  - Positive Ratings percentage (4-5 stars) with gauge bar
  - Recent Activity statistics (last 7 days count and average)
  - **Top Rated Page** block showing highest average rating page with clickable URL
  - **Most Reviewed Page** block showing page with most reviews
  - **User Type Breakdown** (Anonymous vs Authenticated) with mini bar chart

### 🔧 Operations & Management
- **Operations Column** with split button design:
  - Primary "Edit" action button
  - Dropdown toggle for additional actions
  - "Delete" action in secondary dropdown menu
  - Matches Drupal core content admin table style
- **Bulk Operations**:
  - "Select All" checkbox in table header
  - Individual checkboxes for each submission
  - Bulk operations bar showing selected count
  - Bulk delete action with CSRF protection

### ⚙️ Configuration & Customization
- **Frontend Text Configuration**:
  - Admin settings form to configure all frontend widget text
  - Configurable average rating text, reviews text, button labels
  - Editable form title, description, and instructions
  - Customizable success messages and star labels
  - Settings accessible via `/admin/config/dga-rating/settings`
  - All changes cached and invalidated automatically

### 📈 Data Analysis
- **URL-Based Statistics**:
  - Statistics grouped by page/URL
  - Rating distribution per URL
  - Sortable by count, average, or URL
  - Search functionality for filtering URLs
  - Collapsible URL statistics blocks
- **Recent Activity Tracking**:
  - Last 7 days submission count and average rating
  - Last 30 days statistics available
- **User Type Analysis**:
  - Breakdown of submissions by anonymous vs authenticated users
  - Visual mini bar chart representation

### 🎨 User Interface Improvements
- **Enhanced Table Design**:
  - Matches Drupal core content admin table appearance
  - Sticky table header support
  - Better visual hierarchy and sort indicators
- **Collapsible Sections**:
  - Collapsible Filters & Search section
  - Smooth animations for expand/collapse

---

## 🔄 Improvements

- **Compact Statistics Layout**: Optimized card sizes (180px minimum width) for better scalability
- **Better Template Organization**: Streamlined template hierarchy and removed redundant sections
- **Enhanced Code Quality**: Better error handling, type safety, and code organization
- **Performance Optimizations**: Optimized database queries for statistics

---

## 🐛 Bug Fixes

- Fixed SQL error in `getTopRatedPage()` method (HAVING clause issue)
- Fixed Twig syntax error when commenting template sections
- Fixed "Total Pages" and "Average per Page" always showing 0
- Fixed Operations dropdown button not opening
- Fixed InvalidArgumentException in bulk delete operation
- Fixed YAML syntax error in configuration (apostrophe handling)
- Fixed variable passing issues between controller and templates

---

## 🌍 Translation

- All new UI strings are translatable using `$this->t()` or `|t` filter
- JavaScript strings wrapped with `Drupal.t()`
- Fixed pluralization in Twig templates
- All configurable frontend text is translatable

---

## 📋 Technical Details

### New Service Methods
- `getTopRatedPage()`: Returns page with highest average rating
- `getMostReviewedPage()`: Returns page with most reviews
- `getRecentActivity()`: Returns statistics for last 7 and 30 days
- `getPositiveRatingsPercentage()`: Calculates percentage of 4-5 star ratings
- `getSubmissionsByUserType()`: Returns breakdown by anonymous vs authenticated users

### New Forms & Routes
- `DgaRatingSettingsForm`: Configuration form for frontend text
- Routes: `/admin/config/dga-rating/settings`, edit, delete, bulk operations
- Menu link: Settings under DGA Rating Submissions

### Dependencies
- Added `core/dropbutton` library dependency for Operations dropdown

---

## ⚠️ Breaking Changes

**None** - This release maintains full backward compatibility.

---

## 📦 Installation & Upgrade

### For New Installations
1. Download and install the module as usual
2. Clear cache: `drush cr`
3. Configure frontend text at `/admin/config/dga-rating/settings` (optional)

### For Existing Installations
1. Update the module to version 2.0.0
2. Clear cache: `drush cr`
3. Default configuration will be automatically created
4. No database migration required
5. All existing ratings data remains intact

---

## 🎯 Recommended Actions

1. **Review Statistics**: Visit `/admin/dga-rating/submissions` to explore the new dashboard
2. **Customize Text**: Configure frontend widget text at `/admin/config/dga-rating/settings`
3. **Test Operations**: Try the new Edit/Delete dropdown and bulk operations
4. **Clear Cache**: Ensure all changes are visible after clearing cache

---

## 🙏 Acknowledgments

Thank you for using DGA Rating! This release represents a significant enhancement to the admin experience while maintaining the module's core simplicity and accessibility.

---

## 📚 Documentation

- Full changelog: See `CHANGELOG.md`
- Module documentation: See `README.md`
- Issue queue: Report bugs and feature requests

---

## 🔗 Links

- **Module**: [Drupal.org Project Page](https://www.drupal.org/project/dga_rating)
- **Documentation**: See README.md in module directory
- **Design System**: [DGA Design System - Rating Section](https://design.dga.gov.sa/guidelines/templates/rating-section)

---

**Release Date**: January 2025
**Maintainer**: Ahmed Eid Abdelrahim
**Drupal Version**: 10.x, 11.x
**PHP Version**: 8.1+
