<?php

namespace Drupal\dga_rating\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configuration form for DGA Rating widget text settings.
 */
class DgaRatingSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['dga_rating.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'dga_rating_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('dga_rating.settings');

    $form['closed_state'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Closed State (Default View)'),
      '#description' => $this->t('Text displayed when the rating widget is closed.'),
    ];

    $form['closed_state']['average_text'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Average rating text'),
      '#description' => $this->t('Text before the average rating number.'),
      '#default_value' => $config->get('average_text') ?? 'This service is rated with an average of',
      '#required' => TRUE,
    ];

    $form['closed_state']['reviews_text'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Reviews label'),
      '#description' => $this->t('Label for the number of reviews (e.g., "reviews", "ratings").'),
      '#default_value' => $config->get('reviews_text') ?? 'reviews',
      '#required' => TRUE,
    ];

    $form['closed_state']['rate_button_text'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Rate button text'),
      '#description' => $this->t('Text on the button to open the rating form.'),
      '#default_value' => $config->get('rate_button_text') ?? 'Rate this service',
      '#required' => TRUE,
    ];

    $form['form_section'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Rating Form'),
      '#description' => $this->t('Text displayed in the rating form.'),
    ];

    $form['form_section']['form_title'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Form title'),
      '#description' => $this->t('Main title of the rating form.'),
      '#default_value' => $config->get('form_title') ?? 'Tell us what you think of this service',
      '#required' => TRUE,
    ];

    $form['form_section']['form_description'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Form description'),
      '#description' => $this->t('Instructions or description shown below the form title.'),
      '#default_value' => $config->get('form_description') ?? "Please don't include personal or financial information. Your review will be submitted and recorded to improve services.",
      '#required' => TRUE,
    ];

    $form['form_section']['close_button_text'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Close button text'),
      '#default_value' => $config->get('close_button_text') ?? 'Close',
      '#required' => TRUE,
    ];

    $form['form_section']['rating_question'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Rating question'),
      '#description' => $this->t('Question asking users to rate the service.'),
      '#default_value' => $config->get('rating_question') ?? 'How would you rate this service?',
      '#required' => TRUE,
    ];

    $form['form_section']['rating_instructions'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Rating instructions'),
      '#description' => $this->t('Instructions explaining the rating scale.'),
      '#default_value' => $config->get('rating_instructions') ?? 'Rate your experience from (1) poor to (5) excellent',
      '#required' => TRUE,
    ];

    $form['form_section']['rating_aria_label'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Rating ARIA label'),
      '#description' => $this->t('Accessibility label for the rating stars.'),
      '#default_value' => $config->get('rating_aria_label') ?? 'Select rating from 1 to 5',
      '#required' => TRUE,
    ];

    $form['form_section']['feedback_label'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Feedback label'),
      '#default_value' => $config->get('feedback_label') ?? 'Feedback',
      '#required' => TRUE,
    ];

    $form['form_section']['submit_button_text'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Submit button text'),
      '#default_value' => $config->get('submit_button_text') ?? 'Submit',
      '#required' => TRUE,
    ];

    $form['submitted_section'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Submitted State'),
      '#description' => $this->t('Text displayed after a rating is submitted.'),
    ];

    $form['submitted_section']['submitted_rating_text'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Submitted rating text'),
      '#description' => $this->t('Text shown before the user\'s rating.'),
      '#default_value' => $config->get('submitted_rating_text') ?? 'You rated this service as',
      '#required' => TRUE,
    ];

    $form['submitted_section']['submitted_success_text'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Success message'),
      '#description' => $this->t('Message shown when feedback is successfully submitted.'),
      '#default_value' => $config->get('submitted_success_text') ?? 'Your feedback is submitted!',
      '#required' => TRUE,
    ];

    $form['labels'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Rating Labels'),
      '#description' => $this->t('Labels for individual star ratings.'),
    ];

    $form['labels']['star_singular'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Star (singular)'),
      '#default_value' => $config->get('star_singular') ?? 'star',
      '#required' => TRUE,
    ];

    $form['labels']['star_plural'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Stars (plural)'),
      '#default_value' => $config->get('star_plural') ?? 'stars',
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = $this->config('dga_rating.settings');

    // Closed state
    $config->set('average_text', $form_state->getValue('average_text'));
    $config->set('reviews_text', $form_state->getValue('reviews_text'));
    $config->set('rate_button_text', $form_state->getValue('rate_button_text'));

    // Form section
    $config->set('form_title', $form_state->getValue('form_title'));
    $config->set('form_description', $form_state->getValue('form_description'));
    $config->set('close_button_text', $form_state->getValue('close_button_text'));
    $config->set('rating_question', $form_state->getValue('rating_question'));
    $config->set('rating_instructions', $form_state->getValue('rating_instructions'));
    $config->set('rating_aria_label', $form_state->getValue('rating_aria_label'));
    $config->set('feedback_label', $form_state->getValue('feedback_label'));
    $config->set('submit_button_text', $form_state->getValue('submit_button_text'));

    // Submitted section
    $config->set('submitted_rating_text', $form_state->getValue('submitted_rating_text'));
    $config->set('submitted_success_text', $form_state->getValue('submitted_success_text'));

    // Labels
    $config->set('star_singular', $form_state->getValue('star_singular'));
    $config->set('star_plural', $form_state->getValue('star_plural'));

    $config->save();

    parent::submitForm($form, $form_state);
  }

}

