# Changelog

All notable changes to the DGA Rating module will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [2.0.0] - 2025-01-XX

### Added

#### Enhanced Admin Dashboard
- **Advanced Statistics Blocks**: Added comprehensive statistics dashboard with visual indicators
  - Total Submissions with trend indicator (last 7 days activity)
  - Average Rating with progress bar visualization
  - Total Pages and Average per Page metrics
  - Positive Ratings percentage (4-5 stars) with gauge bar
  - Recent Activity statistics (last 7 days count and average)
  - Top Rated Page block showing highest average rating page with URL link
  - Most Reviewed Page block showing page with most reviews
  - User Type breakdown (Anonymous vs Authenticated) with mini bar chart visualization
- **Compact Statistics Layout**: Optimized card sizes and grid layout for better scalability
  - Reduced minimum card width from 240px to 180px for more cards per row
  - Compact padding and spacing for better space utilization
  - Responsive grid that adapts to screen size

#### Operations & Management
- **Operations Column**: Added Operations column to submissions table with split button design
  - Primary "Edit" action button
  - Dropdown toggle button for additional actions
  - "Delete" action in secondary dropdown menu
  - Matches Drupal core content admin table style
- **Bulk Operations**: Implemented bulk selection and deletion functionality
  - "Select All" checkbox in table header
  - Individual checkboxes for each submission row
  - Bulk operations bar showing selected count
  - Bulk delete action with confirmation
  - CSRF token protection for bulk operations

#### Configuration & Customization
- **Frontend Text Configuration**: Added admin settings form to configure all frontend widget text
  - Configurable average rating text
  - Customizable reviews text
  - Editable rate button text
  - Configurable form title and description
  - Customizable close button text
  - Editable rating question and instructions
  - Configurable feedback label and submit button text
  - Customizable success messages
  - Separate singular/plural star text options
  - All settings stored in `dga_rating.settings` configuration
  - Settings accessible via `/admin/config/dga-rating/settings`
  - Cache invalidation on settings change

#### Data Analysis & Reporting
- **URL-Based Statistics**: Enhanced statistics grouped by page/URL
  - Statistics per URL with detailed breakdowns
  - Rating distribution per URL
  - Sortable by count, average rating, or URL
  - Configurable display limit (10, 20, 50, 100)
  - Search functionality for filtering URLs
  - Collapsible URL statistics blocks
- **Recent Activity Tracking**: Time-based statistics
  - Last 7 days submission count and average rating
  - Last 30 days statistics (for future use)
- **User Type Analysis**: Breakdown of submissions by user type
  - Anonymous user submissions count
  - Authenticated user submissions count
  - Visual mini bar chart representation

#### User Interface Improvements
- **Enhanced Table Design**: Improved submissions table styling
  - Matches Drupal core content admin table appearance
  - Sticky table header support
  - Better visual hierarchy
  - Improved sort indicators
- **Collapsible Sections**: Added collapsible UI elements for better organization
  - Collapsible Filters & Search section
  - Smooth animations for expand/collapse
- **View Mode Toggle**: Compact/Detailed view options (removed in favor of streamlined design)

#### Developer Experience
- **New Service Methods**: Added service methods for advanced statistics
  - `getTopRatedPage()`: Returns page with highest average rating
  - `getMostReviewedPage()`: Returns page with most reviews
  - `getRecentActivity()`: Returns statistics for last 7 and 30 days
  - `getPositiveRatingsPercentage()`: Calculates percentage of 4-5 star ratings
  - `getSubmissionsByUserType()`: Returns breakdown by anonymous vs authenticated users
- **Enhanced Form API**: New configuration form base
  - `DgaRatingSettingsForm`: Extends ConfigFormBase for settings management
  - Proper schema validation via `dga_rating.schema.yml`
  - Default configuration via `dga_rating.settings.yml`

### Changed

#### Template Improvements
- **Enhanced Statistics Display**: Redesigned statistics cards with visual elements
  - Progress bars for rating percentages
  - Gauge bars for metric visualization
  - Trend indicators for temporal data
  - Mini charts for user type distribution
  - Clickable URL links in statistics cards
  - Color-coded card borders for visual distinction
- **Improved Template Structure**: Better organization and maintainability
  - Removed redundant URL statistics section (data now in Overall Statistics)
  - Streamlined template hierarchy
  - Better variable handling and defaults

#### Code Quality
- **Improved Error Handling**: Better exception handling in service methods
- **Enhanced Type Safety**: Better type casting and null checks
- **Code Organization**: Better separation of concerns
- **Performance**: Optimized database queries for statistics

### Fixed

#### Critical Fixes
- **SQL Error**: Fixed HAVING clause issue in `getTopRatedPage()` method
  - Removed problematic `havingCondition()` with aggregate function
  - Simplified query logic
- **Twig Syntax Error**: Fixed template syntax error when commenting out URL statistics section
  - Properly removed commented code to avoid parsing errors

#### Data Display Fixes
- **Zero Values Fix**: Fixed "Total Pages" and "Average per Page" always showing 0
  - Corrected variable passing from controller to template
  - Added proper preprocess function for variable extraction
  - Fixed render array key handling
- **Variable Passing**: Ensured all template variables are properly passed and initialized
  - Added `#` prefix for render array properties
  - Proper variable extraction in preprocess function
  - Default values for all variables

#### User Interface Fixes
- **Operations Dropdown**: Fixed dropdown button not opening
  - Improved event handling for toggle button
  - Better z-index and pointer-events CSS
  - Proper event propagation handling
- **Bulk Operations**: Fixed InvalidArgumentException in bulk delete
  - Proper handling of array and scalar request parameters
  - Correct CSRF token retrieval and validation

#### Configuration Fixes
- **YAML Syntax Error**: Fixed apostrophe handling in configuration defaults
  - Changed single quotes to double quotes for `form_description` field
  - Fixed in settings form, schema, and default config files

### Translation

- **Enhanced Translatability**: Improved translation support throughout
  - All new UI strings use `$this->t()` or `|t` filter
  - JavaScript strings wrapped with `Drupal.t()`
  - Fixed pluralization in Twig templates
  - All configurable frontend text is translatable

### Technical Details

- **Dependencies**: Added `core/dropbutton` library dependency for Operations dropdown
- **Cache**: Added cache tags for settings configuration
- **Routes**: Added new routes for settings, edit, delete, and bulk operations
- **Menu Links**: Added Settings menu link under DGA Rating Submissions

### Breaking Changes

- None (maintains backward compatibility)

### Migration Notes

- Existing installations will automatically get default configuration values
- No database schema changes required
- Existing ratings data remains intact

---

## [1.0.0] - Previous Release

### Initial Release Features
- Basic 1-5 star rating widget
- Optional feedback field
- Admin submissions listing
- Basic statistics display
- URL and entity-based rating tracking
