<?php

namespace Drupal\dga_rating\Plugin\Menu;

use Drupal\Core\Menu\MenuLinkDefault;

/**
 * Custom menu link plugin for DGA Rating with icon support.
 */
class DgaRatingMenuLink extends MenuLinkDefault {

  /**
   * {@inheritdoc}
   */
  public function getTitle() {
    // Load translation from config based on current language
    $config = \Drupal::config('dga_rating.settings');
    $language_manager = \Drupal::languageManager();
    $current_lang = $language_manager->getCurrentLanguage()->getId();
    $is_arabic = ($current_lang === 'ar');
    
    if ($is_arabic) {
      $title = $config->get('menu_title_dga_rating_ar');
      if (!empty($title)) {
        return $title;
      }
      // Fallback to English
      $title = $config->get('menu_title_dga_rating_en');
      if (!empty($title)) {
        return $title;
      }
      return 'تقييم DGA';
    }
    else {
      $title = $config->get('menu_title_dga_rating_en');
      if (!empty($title)) {
        return $title;
      }
      return 'DGA Rating';
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    // Description can stay static or be translated via config if needed
    return 'DGA Rating administration';
  }

  /**
   * {@inheritdoc}
   */
  public function getOptions() {
    $options = parent::getOptions();
    
    // Add icon class and data attribute
    if (!isset($options['attributes'])) {
      $options['attributes'] = [];
    }
    if (!isset($options['attributes']['class'])) {
      $options['attributes']['class'] = [];
    }
    if (!in_array('toolbar-icon--dga-rating', $options['attributes']['class'])) {
      $options['attributes']['class'][] = 'toolbar-icon--dga-rating';
    }
    $options['attributes']['data-icon'] = 'dga-rating';
    
    return $options;
  }

}

