<?php

namespace Drupal\dga_rating\Plugin\Menu;

use Drupal\Core\Menu\MenuLinkDefault;

/**
 * Custom menu link plugin for Translations with translation support.
 */
class DgaRatingTranslationsMenuLink extends MenuLinkDefault {

  /**
   * {@inheritdoc}
   */
  public function getTitle() {
    // Load translation from config based on current language
    $config = \Drupal::config('dga_rating.settings');
    $language_manager = \Drupal::languageManager();
    $current_lang = $language_manager->getCurrentLanguage()->getId();
    $is_arabic = ($current_lang === 'ar');
    
    if ($is_arabic) {
      $title = $config->get('menu_title_translations_ar');
      if (!empty($title)) {
        return $title;
      }
      // Fallback to English
      $title = $config->get('menu_title_translations_en');
      if (!empty($title)) {
        return $title;
      }
      return 'الترجمات';
    }
    else {
      $title = $config->get('menu_title_translations_en');
      if (!empty($title)) {
        return $title;
      }
      return 'Translations';
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return 'Configure English and Arabic translations for all front-end text';
  }

}

