<?php

namespace Drupal\dga_rating\Plugin\Menu\LocalTask;

use Drupal\Core\Menu\LocalTaskDefault;
use Symfony\Component\HttpFoundation\Request;

/**
 * Local task plugin for Rating Dashboard with config-based translation.
 */
class DgaRatingDashboardTask extends LocalTaskDefault {

  /**
   * {@inheritdoc}
   */
  public function getTitle(?Request $request = NULL) {
    // Load translation from config based on current language
    $config = \Drupal::config('dga_rating.settings');
    $language_manager = \Drupal::languageManager();
    $current_lang = $language_manager->getCurrentLanguage()->getId();
    $is_arabic = ($current_lang === 'ar');
    
    if ($is_arabic) {
      $title = $config->get('menu_title_dashboard_ar');
      if (!empty($title)) {
        return $title;
      }
      // Fallback to English
      $title = $config->get('menu_title_dashboard_en');
      if (!empty($title)) {
        return $title;
      }
      return 'لوحة تحكم التقييمات';
    }
    else {
      $title = $config->get('menu_title_dashboard_en');
      if (!empty($title)) {
        return $title;
      }
      return 'Rating Dashboard';
    }
  }

}

