# Release Notes for DGA Rating 2.0.0

## 🎉 Major Release: Enhanced Admin Dashboard & Advanced Features

This release introduces a comprehensive admin dashboard overhaul with advanced statistics, bulk operations, and extensive configuration options.

---

## ✨ New Features

### 📊 Advanced Statistics Dashboard
- **Comprehensive Statistics Blocks** with visual indicators:
  - Total Submissions with trend indicator (shows last 7 days activity)
  - Average Rating with progress bar visualization
  - Total Pages and Average per Page metrics
  - Positive Ratings percentage (4-5 stars) with gauge bar
  - Recent Activity statistics (last 7 days count and average)
  - **Top Rated Page** block showing highest average rating page with clickable URL
  - **Most Reviewed Page** block showing page with most reviews
  - **User Type Breakdown** (Anonymous vs Authenticated) with mini bar chart

### 🔧 Operations & Management
- **Operations Column** with split button design:
  - Primary "Edit" action button
  - Dropdown toggle for additional actions
  - "Delete" action in secondary dropdown menu
  - Matches Drupal core content admin table style
- **Bulk Operations**:
  - "Select All" checkbox in table header
  - Individual checkboxes for each submission
  - Bulk operations bar showing selected count
  - Bulk delete action with CSRF protection

### ⚙️ Configuration & Customization
- **Frontend Text Configuration**:
  - Admin settings form to configure all frontend widget text
  - Configurable average rating text, reviews text, button labels
  - Editable form title, description, and instructions
  - Customizable success messages and star labels
  - Settings accessible via `/admin/config/dga-rating/settings`
  - All changes cached and invalidated automatically
- **UI-Based Translation System**:
  - Complete bilingual translation management (English & Arabic)
  - No `.po` files required - all translations managed through admin interface
  - Translation form accessible via **DGA Rating > Translations**
  - Menu item translations (DGA Rating, Rating Dashboard, Settings, Translations)
  - Validation error messages are translatable
  - Dynamic translation loading based on current language
  - All translations stored in Drupal config (exportable/importable)
- **Widget Behavior Configuration**:
  - Configurable refresh delay after successful submission (default: 3 seconds)
  - Settings accessible via **DGA Rating > Settings**

### 📈 Data Analysis
- **URL-Based Statistics**:
  - Statistics grouped by page/URL
  - Rating distribution per URL
  - Sortable by count, average, or URL
  - Search functionality for filtering URLs
  - Collapsible URL statistics blocks
- **Recent Activity Tracking**:
  - Last 7 days submission count and average rating
  - Last 30 days statistics available
- **User Type Analysis**:
  - Breakdown of submissions by anonymous vs authenticated users
  - Visual mini bar chart representation

### 🎨 User Interface Improvements
- **Enhanced Table Design**:
  - Matches Drupal core content admin table appearance
  - Sticky table header support
  - Better visual hierarchy and sort indicators
- **Collapsible Sections**:
  - Collapsible Filters & Search section
  - Smooth animations for expand/collapse
- **Custom Menu Structure**:
  - Reorganized admin menu with hierarchical structure
  - Main menu item: "DGA Rating" with custom SVG star icon
  - Sub-items: "Rating Dashboard", "Settings", "Translations"
  - Parent menu item only appears in sidebar (not as tab)
  - All menu items are translatable via Translations form
- **Inline Form Validation**:
  - Inline error messages displayed under each field (not popups)
  - Error messages are translatable via admin interface
  - Red error styling matching Drupal core patterns
  - All form inputs are required and validated
- **Auto-Refresh Widget**:
  - Widget automatically refreshes after successful submission
  - Configurable delay (default: 3 seconds)
  - Returns to closed state, ready for next submission
  - AJAX-based refresh without page reload

---

## 🔄 Improvements

- **Compact Statistics Layout**: Optimized card sizes (180px minimum width) for better scalability
- **Better Template Organization**: Streamlined template hierarchy and removed redundant sections
- **Enhanced Code Quality**: Better error handling, type safety, and code organization
- **Performance Optimizations**: Optimized database queries for statistics

---

## 🐛 Bug Fixes

- Fixed SQL error in `getTopRatedPage()` method (HAVING clause issue)
- Fixed Twig syntax error when commenting template sections
- Fixed "Total Pages" and "Average per Page" always showing 0
- Fixed Operations dropdown button not opening
- Fixed InvalidArgumentException in bulk delete operation
- Fixed YAML syntax error in configuration (apostrophe handling)
- Fixed variable passing issues between controller and templates

---

## 🌍 Translation

- **UI-Based Translation System**: Complete overhaul of translation system
  - Removed dependency on `.po` files
  - All translations managed through admin interface (`RatingTranslationForm`)
  - Bilingual support (English & Arabic) for all frontend text
  - Menu item translations (DGA Rating, Rating Dashboard, Settings, Translations)
  - Validation error messages are translatable
  - Dynamic translation loading based on current language
  - Fallback system: Arabic → English → hardcoded defaults
  - All translations stored in Drupal config (exportable/importable)
- All new UI strings are translatable using `$this->t()` or `|t` filter
- JavaScript strings wrapped with `Drupal.t()`
- Fixed pluralization in Twig templates
- All configurable frontend text is translatable

---

## 📋 Technical Details

### New Service Methods
- `getTopRatedPage()`: Returns page with highest average rating
- `getMostReviewedPage()`: Returns page with most reviews
- `getRecentActivity()`: Returns statistics for last 7 and 30 days
- `getPositiveRatingsPercentage()`: Calculates percentage of 4-5 star ratings
- `getSubmissionsByUserType()`: Returns breakdown by anonymous vs authenticated users

### New Forms & Routes
- `DgaRatingSettingsForm`: Configuration form for widget behavior and security settings
- `RatingTranslationForm`: Bilingual translation form for all frontend text
- Routes: `/admin/config/dga-rating/settings`, `/admin/content/dga-rating/translations`, edit, delete, bulk operations
- Menu structure: DGA Rating → Rating Dashboard, Settings, Translations

### Custom Menu Plugins
- `DgaRatingMenuLink`: Main menu item with SVG icon support
- `DgaRatingDashboardMenuLink`, `DgaRatingSettingsMenuLink`, `DgaRatingTranslationsMenuLink`: Sub-menu items
- `DgaRatingDashboardTask`, `DgaRatingSettingsTask`, `DgaRatingTranslationsTask`: Local task plugins
- All plugins support config-based translations

### Dependencies
- Added `core/dropbutton` library dependency for Operations dropdown

---

## ⚠️ Breaking Changes

**None** - This release maintains full backward compatibility.

---

## 📦 Installation & Upgrade

### For New Installations
1. Download and install the module as usual
2. Clear cache: `drush cr`
3. Configure translations at **DGA Rating > Translations** (optional - defaults are provided)
4. Configure widget behavior at **DGA Rating > Settings** (optional - defaults are provided)

### For Existing Installations
1. Update the module to version 2.0.0
2. Clear cache: `drush cr`
3. Default configuration will be automatically created
4. No database migration required
5. All existing ratings data remains intact

---

## 🎯 Recommended Actions

1. **Review Statistics**: Visit **DGA Rating > Rating Dashboard** to explore the new dashboard
2. **Configure Translations**: Set up English and Arabic translations at **DGA Rating > Translations**
3. **Configure Settings**: Adjust widget behavior and security settings at **DGA Rating > Settings**
4. **Test Operations**: Try the new Edit/Delete dropdown and bulk operations
5. **Test Widget**: Place the rating block and test the inline validation and auto-refresh features
6. **Clear Cache**: Ensure all changes are visible after clearing cache

---

## 🙏 Acknowledgments

Thank you for using DGA Rating! This release represents a significant enhancement to the admin experience while maintaining the module's core simplicity and accessibility.

---

## 📚 Documentation

- Full changelog: See `CHANGELOG.md`
- Module documentation: See `README.md`
- Issue queue: Report bugs and feature requests

---

## 🔗 Links

- **Module**: [Drupal.org Project Page](https://www.drupal.org/project/dga_rating)
- **Documentation**: See README.md in module directory
- **Design System**: [DGA Design System - Rating Section](https://design.dga.gov.sa/guidelines/templates/rating-section)

---

**Release Date**: January 2025
**Maintainer**: Ahmed Eid Abdelrahim
**Drupal Version**: 10.x, 11.x
**PHP Version**: 8.1+
