<?php

namespace Drupal\dga_rating\Plugin\Menu;

use Drupal\Core\Menu\MenuLinkDefault;

/**
 * Custom menu link plugin for Settings with translation support.
 */
class DgaRatingSettingsMenuLink extends MenuLinkDefault {

  /**
   * {@inheritdoc}
   */
  public function getTitle() {
    // Load translation from config based on current language
    $config = \Drupal::config('dga_rating.settings');
    $language_manager = \Drupal::languageManager();
    $current_lang = $language_manager->getCurrentLanguage()->getId();
    $is_arabic = ($current_lang === 'ar');
    
    if ($is_arabic) {
      $title = $config->get('menu_title_settings_ar');
      if (!empty($title)) {
        return $title;
      }
      // Fallback to English
      $title = $config->get('menu_title_settings_en');
      if (!empty($title)) {
        return $title;
      }
      return 'الإعدادات';
    }
    else {
      $title = $config->get('menu_title_settings_en');
      if (!empty($title)) {
        return $title;
      }
      return 'Settings';
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return 'Configure frontend text and labels';
  }

}

