# DGA Rating

A fully compliant, accessible, and user-centric rating widget for Drupal 10 & 11, designed in alignment with the **Digital Government Authority (DGA)** Design System standards.

This module delivers an elegant, intuitive 1–5 star rating experience with optional written feedback, allowing visitors to easily evaluate services, content pages, or any entity type.
Built with performance, security, and usability in mind, it ensures seamless integration into government-grade digital services.

> **Design System Compliance**: This module implements the **Rating Section** template from the [DGA Design System](https://design.dga.gov.sa/guidelines/templates/rating-section), following official design guidelines and best practices, ensuring full alignment with national design guidelines, accessibility requirements, and UI best practices.

## Features

### Frontend Widget Features
- **Interactive Rating Widget**: Star-based rating system (1-5 stars)
- **Optional Feedback**: Text area for detailed user feedback
- **Dynamic Statistics**: Automatically calculates and displays:
  - Average rating (e.g., "3.9")
  - Total number of reviews (e.g., "1544 reviews")
- **AJAX Submission**: Asynchronous rating submission without page reload
- **Entity Support**: Can track ratings by entity (node, user, etc.) or by URL
- **Anonymous Support**: Works for both authenticated and anonymous users
- **Accessibility**: Keyboard navigation and ARIA labels for screen readers
- **Responsive Design**: Mobile-friendly layout
- **UI-Based Translations**: All frontend text (English & Arabic) is managed through admin interface - no `.po` files needed
- **Configurable Text**: All frontend widget text is customizable via admin settings
- **Inline Validation**: Form validation with inline error messages (translatable)
- **Auto-Refresh**: Widget automatically refreshes after successful submission (configurable delay)

### Admin Dashboard Features (v2.0.0)
- **Advanced Statistics Dashboard**:
  - Total Submissions with trend indicator (last 7 days activity)
  - Average Rating with progress bar visualization
  - Total Pages and Average per Page metrics
  - Positive Ratings percentage (4-5 stars) with gauge bar
  - Recent Activity statistics (last 7 days count and average)
  - Top Rated Page block (highest average rating)
  - Most Reviewed Page block (most reviews)
  - User Type breakdown (Anonymous vs Authenticated) with visual chart
  - Compact, scalable grid layout

- **Submissions Management**:
  - Enhanced submissions table matching Drupal core admin style
  - Operations column with split button (Edit/Delete dropdown)
  - Bulk operations (select all, bulk delete)
  - Multi-column sorting (ID, Rating, Date, URL, etc.)
  - Advanced filtering (URL, Rating, Entity Type/ID, Date range)
  - Pagination support

- **Configuration**:
  - Admin settings form to configure all frontend widget text
  - Customizable labels, messages, and button text
  - Settings accessible via `/admin/config/dga-rating/settings`
  - Configurable widget refresh delay after submission
- **Translation Management**:
  - Bilingual translation form (English & Arabic) for all frontend text
  - Menu item translations (DGA Rating, Rating Dashboard, Settings, Translations)
  - Validation error messages are translatable
  - All translations stored in Drupal config (exportable/importable)
  - No `.po` files required - fully UI-based translation management

## Requirements

- Drupal 10.x or 11.x
- PHP 8.1 or higher
- No external dependencies

## Installation

1. **Download/Clone the module**
   - Place the `dga_rating` folder in `web/modules/custom/` directory
   - Or use Composer: (if published to drupal.org)

2. **Enable the module**
   ```bash
   drush en dga_rating
   ```
   Or navigate to `/admin/modules` and enable "DGA Rating"

3. **Clear cache**
   ```bash
   drush cr
   ```

## Usage

### Block Placement

1. Navigate to **Structure > Block layout** (or your theme's block management)
2. Find the **"DGA Rating Widget"** block
3. Place it in your desired region (e.g., Content, Sidebar, Footer)
4. Configure block settings as needed
5. Save the block layout

### Admin Configuration

#### Menu Structure

The module provides a hierarchical menu structure in the admin sidebar:
- **DGA Rating** (main menu with SVG star icon)
  - **Rating Dashboard** - View all submissions and statistics
  - **Settings** - Configure widget behavior and security settings
  - **Translations** - Manage English and Arabic translations for all frontend text

All menu items are translatable via the Translations form.

#### Configure Frontend Widget Text & Translations

1. Navigate to **DGA Rating > Translations** (`/admin/content/dga-rating/translations`)
2. Configure bilingual translations (English & Arabic) for:
   - Widget text (average text, reviews text, button labels)
   - Form elements (title, description, questions, instructions)
   - Success and error messages
   - Validation error messages
   - Menu item titles (DGA Rating, Rating Dashboard, Settings, Translations)
3. Save configuration
4. Changes take effect immediately (cache is automatically cleared)

#### Configure Widget Behavior

1. Navigate to **DGA Rating > Settings** (`/admin/config/dga-rating/settings`)
2. Configure:
   - Widget refresh delay (seconds) - Time to wait before refreshing widget after successful submission
   - Rate limiting settings (submissions per IP address)
   - Feedback field maximum length
3. Save configuration

#### View and Manage Submissions

1. Navigate to **DGA Rating > Rating Dashboard** (`/admin/content/dga-rating`)
2. View comprehensive statistics dashboard
3. Filter and sort submissions as needed
4. Edit or delete individual submissions using the Operations dropdown
5. Use bulk operations to delete multiple submissions at once

### Admin Dashboard Overview

The admin dashboard provides:
- **Overall Statistics**: Key metrics with visual indicators
- **Rating Distribution**: Visual breakdown of ratings (1-5 stars)
- **Filters & Search**: Advanced filtering options
- **Submissions Table**: Full list of all submissions with operations

### How It Works

The rating widget automatically:
- Detects the current page context (node, URL, etc.)
- Fetches existing statistics (average rating and review count)
- Updates statistics dynamically after each submission

**Default View (Closed State):**
- Shows average rating (e.g., "3.9")
- Displays total review count (e.g., "1544 reviews")
- Provides a "Rate this service" button

**Form View (Open State):**
- **Primary Question**: "How do you rate this service?" - The most important element in the rating section
- Interactive star rating (1-5 stars) - Allows users to provide specific numeric feedback that reflects whether the service is useful or not useful
- Optional feedback textarea
- Links to e-participation statement and rules of engagement
- Submit button

**Confirmation View (Submitted):**
- Success message: After the user submits the rating, a confirmation message appears showing that the response has been sent successfully
- Shows user's submitted rating
- Widget automatically refreshes after a configurable delay (default: 3 seconds)
- Returns to closed state, ready for the next submission
- Updated statistics are reflected in the closed view

### Key Design Requirements

1. **Rating Question**: The most important element is the question "How do you rate this service?" accompanied by the star rating element
2. **Numeric Feedback**: Specific numbers (1-5 stars) reflect whether the service is useful or not useful, facilitating precise identification of problems or strengths
3. **Success Confirmation**: After submission, a confirmation message appears showing that the response has been sent successfully
4. **Mobile Responsive**: In the mobile version, buttons are positioned below the text to ensure better user experience and smoother formatting on small screens

For full design guidelines, refer to: [DGA Design System - Rating Section](https://design.dga.gov.sa/guidelines/templates/rating-section)

## Theming

### Override the Template

Copy `templates/dga-rating-widget.html.twig` to your theme:
```
your_theme/
  templates/
    dga-rating-widget.html.twig
```

When overriding, ensure you maintain compliance with the DGA Design System guidelines.

### Override CSS

The module includes basic CSS styling following DGA Design System standards. To customize:
1. Add CSS to your theme that targets `.rating-widget` classes
2. Use CSS specificity or `!important` to override module styles
3. See `css/rating.css` for available classes
4. Maintain design system compliance when customizing

### Template Variables

Available variables in `dga-rating-widget.html.twig`:
- `average`: Average rating (string, e.g., "3.9")
- `count`: Total number of reviews (integer)
- `url`: Current URL path (string)
- `entity_type`: Entity type if available (string or NULL)
- `entity_id`: Entity ID if available (integer or NULL)
- `texts`: Array of configurable text strings (v2.0.0):
  - `average_text`: Text for average rating display
  - `reviews_text`: Text for reviews count
  - `rate_button_text`: Rate button label
  - `form_title`: Form title
  - `form_description`: Form description
  - `close_button_text`: Close button label
  - `rating_question`: Rating question text
  - `rating_instructions`: Rating instructions
  - `feedback_label`: Feedback field label
  - `submit_button_text`: Submit button label
  - `submitted_rating_text`: Submitted rating confirmation text
  - `submitted_success_text`: Success message
  - `star_singular`: Singular form of "star"
  - `star_plural`: Plural form of "stars"

### Design System Resources

- **Official Guidelines**: [DGA Design System - Rating Section](https://design.dga.gov.sa/guidelines/templates/rating-section)
- **Template Preview**: Available on the design system website
- **Code Examples**: Refer to the design system documentation
- **Figma Design**: Link available on the design system page

## Security Considerations

- The module uses Drupal's CSRF protection for AJAX requests
- IP addresses are stored for abuse prevention (can be anonymized if needed)
- Ratings can be submitted by anonymous users (configurable via permissions)
- All user input is sanitized before database storage

## Troubleshooting

### Ratings not submitting
- Check browser console for JavaScript errors
- Verify CSRF token is included in requests
- Check database table exists: `drush sql-query "DESCRIBE dga_rating;"`

### Statistics not updating
- Clear Drupal cache: `drush cr`
- Verify JavaScript file is loading: Check browser Network tab
- Check module is enabled: `drush pm:list --filter=dga_rating`

### Styles not appearing
- Clear cache: `drush cr`
- Check CSS file is loading in browser DevTools
- Verify library is attached (check block build output)

### Admin Dashboard Issues
- **Statistics showing zero**: Clear cache and verify database queries are working
- **Operations dropdown not opening**: Clear browser cache and verify JavaScript is loaded
- **Bulk operations not working**: Check CSRF token is valid, clear cache
- **Settings not saving**: Verify file permissions on config directory

## Uninstallation

1. Disable and uninstall the module:
   ```bash
   drush pmu dga_rating
   ```
   Or navigate to `/admin/modules`, disable and uninstall "DGA Rating"

2. The `dga_rating` database table is **automatically dropped** when the module is uninstalled.

   > **Warning**: All rating data will be permanently deleted. If you need to preserve the data, export it before uninstalling the module.

## Translation System

### UI-Based Translations (No .po Files)

The module uses a fully UI-based translation system:
- **No `.po` files required** - All translations are managed through the admin interface
- **Bilingual Support**: English and Arabic translations for all frontend text
- **Menu Item Translations**: All admin menu items are translatable
- **Config Storage**: Translations stored in Drupal config system (exportable/importable)
- **Dynamic Loading**: Translations are loaded based on current language context
- **Fallback System**: Falls back to English if Arabic translation is missing, then to hardcoded defaults

### Translation Form

Access the translation form at **DGA Rating > Translations** (`/admin/content/dga-rating/translations`).

The form provides:
- Two-column layout (English | Arabic)
- Sections for:
  - Widget Text (average, reviews, buttons)
  - Form Elements (title, description, questions)
  - Messages (success, error, validation)
  - Menu Items (all admin menu titles)
- All fields are required and validated
- Changes take effect immediately after saving

## Version History

### Version 2.0.0 (January 2025)
- ✨ Major release with enhanced admin dashboard
- 📊 Advanced statistics blocks with visual indicators
- 🔧 Operations column with Edit/Delete dropdown
- 📦 Bulk operations support
- ⚙️ Frontend text configuration
- 📈 URL-based statistics and analysis
- 🌍 **UI-based translation system** (English & Arabic, no `.po` files)
- 🎨 **Custom menu structure** with SVG icon
- ✅ **Inline form validation** with translatable error messages
- 🔄 **Auto-refresh widget** after submission (configurable delay)
- 🐛 Various bug fixes and improvements

### Version 1.0.0
- Initial release with basic rating widget
- Admin submissions listing
- Basic statistics display

For detailed changelog, see [CHANGELOG.md](CHANGELOG.md)
