<?php

namespace Drupal\diboo_core\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\node\NodeInterface;

/**
 * Returns responses for Diboo frontpage.
 */
final class DibooFrontPage extends ControllerBase {

  /**
   * Builds the response.
   */
  public function __invoke(): array {
    $build = [];
    $build['content'] = [
      '#theme' => 'diboo_frontpage',
      '#title' => 'Diboo',
      '#subtitle' => $this->t('Kick things off with a simple phrase, then let others take turns drawing and describing. They will only see the step right before theirs. It won’t take long before the original message goes wildly off course and turns into something hilariously different!'),
      '#call_to_action' => $this->t('Play'),
      '#list_title' => $this->t('How it comes together'),
      '#list_items' => [
        $this->t('A player picks a phrase randomly (e.g., A cat is having tea)'),
        $this->t('Another player takes a look and describes the drawing in words'),
        $this->t('Someone else grabs that description and turns it back into a drawing'),
        $this->t('Keep swapping between describing and drawing until everyone has joined the fun!'),
        $this->t('Finally, reveal the wild and funny twist the message has taken!'),
      ],
      '#access' => $this->currentUser()->isAnonymous(),
      '#cache' => ['contexts' => ['user.roles:anonymous']],
    ];

    $rooms = $this->entityTypeManager()->getStorage('node')->loadByProperties([
      'type' => 'diboo_room',
      'status' => NodeInterface::PUBLISHED,
    ]);

    $build['rooms'] = $this->entityTypeManager()->getViewBuilder('node')->viewMultiple($rooms);

    return $build;
  }

}
