<?php

namespace Drupal\diboo_core\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hook for behaving as if Manage display module is installed.
 */
class ManageDisplayReplacement {

  /**
   * Implements hook_preprocess_HOOK().
   *
   * Restore expected variables when
   * https://www.drupal.org/project/manage_display
   * is not installed.
   */
  #[Hook('preprocess_node')]
  public function preprocessNode(&$variables): void {
    if (isset($variables['author_name']) && !isset($variables['content']['uid'])) {
      $variables['content']['uid'] = $variables['author_name'];
    }
  }

}
