<?php

namespace Drupal\diboo_core\Hook;

use Drupal\Core\Entity\Display\EntityViewDisplayInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hook for adding a library when viewing chains.
 */
class ChainView {

  /**
   * Implements hook_ENTITY_TYPE_view().
   */
  #[Hook('node_view')]
  public function nodeView(array &$build, EntityInterface $node, EntityViewDisplayInterface $display, $view_mode): void {
    if ($node->bundle() !== 'diboo_chain' || $view_mode !== 'full') {
      return;
    }
    $build['#attached']['library']['diboo_core/chain-full-display'] = 'diboo_core/chain-full-display';
  }

}
