# D-ID AI Provider

This module integrates the [D-ID](https://www.d-id.com/) video generation service with Drupal's **AI Automators** system. It lets you generate talking-head videos from audio and either a still image or a pre-made D-ID presenter.  

---

<h3 id="module-project--features">Features</h3>

- Provides a new **AI Provider plugin** for D-ID.  
- Adds an **AI Automator type**: *Image + Audio → Video*.  
- Lets editors configure an **image field** or choose a **presenter** when no image is provided.  
- Supports facial expression options (neutral, happy, surprised, serious, angry, sad).  
- Uses batch processing for video generation with retry handling.  
- Stores generated video files directly in Drupal (`public://did_videos`).  

---

<h3 id="module-project--post-installation">Post-Installation</h3>

1. Go to **Configuration → AI → D-ID Provider settings** and set your API key (via the Key module).  
2. Add a **file field** on your content type to store generated videos.  
3. In the field settings, enable the **D-ID: Image + Audio → Video** automator.  
4. Choose either:  
   - an **Image field + Audio field** for custom avatars, or  
   - select **No image — use presenter** and pick a D-ID stock presenter.  
5. Save content with audio attached, and the module will generate a video.  

---

<h3 id="module-project--additional-requirements">Additional Requirements</h3>

- Drupal core 11+.  
- [AI](https://www.drupal.org/project/ai) module.  
- [Key](https://www.drupal.org/project/key) module (to securely store the D-ID API key).  
- A valid [D-ID API account](https://www.d-id.com/).  





<h3 id="module-project--similar-projects">Similar projects</h3>

- This project **replaces the old D-ID module** that was built on the now-deprecated *AI Interpolator* system.  
- Unlike the old module, this one works with **AI Automators** and provides full integration with modern AI workflows.  

---

<h3 id="module-project--support">Supporting this Module</h3>

Development is community-driven. Feedback, issues, and contributions are welcome on Drupal.org.  

---

