<?php

namespace Drupal\dify_widget_vanilla\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\dify\Service\DifyConfigurationService;
use Symfony\Component\DependencyInjection\ContainerInterface;


/**
 * Dify Widget JS Configuration delete form.
 */
class DifyWidgetVanillaConfigDeleteForm extends ConfirmFormBase {

  /**
   * The Dify configuration service.
   *
   * @var \Drupal\dify\Service\DifyConfigurationService
   */
  protected DifyConfigurationService $configurationService;

  /**
   * Constructs a DifyWidgetVanillaConfigDeleteForm object.
   *
   * @param \Drupal\dify\Service\DifyConfigurationService $configuration_service
   *   The Dify configuration service.
   */
  public function __construct(DifyConfigurationService $configuration_service) {
    $this->configurationService = $configuration_service;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('dify.configuration_service')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'dify_widget_vanilla_config_delete_form';
  }

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    $name = \Drupal::request()->get('name');
    return $this->t('Are you sure you want to delete the configuration "@name"?', ['@name' => $name]);
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return $this->t('This action cannot be undone. Widgets using this configuration will stop working.');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return new Url('dify_widget_vanilla.config_list');
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Delete');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $name = \Drupal::request()->get('name');

    if ($this->configurationService->deleteConfiguration('widget_js', $name)) {
      $this->messenger()->addMessage($this->t('Configuration "@name" has been deleted.', ['@name' => $name]));
    } else {
      $this->messenger()->addError($this->t('Failed to delete configuration "@name".', ['@name' => $name]));
    }

    $form_state->setRedirectUrl($this->getCancelUrl());
  }

}
