# Dify Integration for Drupal

A comprehensive Drupal module suite that integrates Dify AI platform with Drupal, providing intelligent chatbot functionality and content indexing capabilities. This module enables you to create AI-powered chatbots that can answer questions based on your Drupal site content.

## Overview

The Dify module provides a modular architecture with three specialized submodules:

- **dify_search_api**: Search API backend for indexing Drupal content to Dify knowledge base
- **dify_widget_official**: Official Dify widget integration using Dify's embed script
- **dify_widget_vanilla**: Custom-built chatbot widget with advanced features and direct API integration

## Key Features

- **Multiple Widget Options**: Choose between official Dify widget or custom vanilla widget
- **Content Indexing**: Automatically index Drupal content to Dify knowledge base via Search API
- **Intelligent Responses**: AI-powered chatbot that answers questions based on your site content
- **Secure Configuration**: All credentials stored securely using Drupal's state system
- **Authentication Control**: Restrict chatbot access to authenticated users
- **Metadata Support**: Automatic content URL linking for source attribution
- **Multi-configuration Support**: Manage multiple Dify configurations for different use cases

## Submodules

### Dify Search API (`dify_search_api`)
Provides a Search API backend that indexes Drupal content to Dify knowledge base. Supports both text and CSV file indexing modes with automatic metadata handling.

### Dify Widget Official (`dify_widget_official`)
Integrates the official Dify chatbot widget using Dify's embed script. Provides site-wide automatic integration with minimal configuration.

### Dify Widget Vanilla (`dify_widget_vanilla`)
A custom-built chatbot widget with advanced features including:
- Real-time streaming responses (SSE)
- Conversation history persistence
- Customizable themes and colors
- Block-based placement
- Enhanced user interface

## Installation

### Via Drush
```bash
drush pm-enable dify
```

### Via Drupal Admin
1. Navigate to **Extend** (`/admin/modules`)
2. Enable "Dify" module
3. Optionally enable desired submodules

## Configuration

### 1. Search API Backend (dify_search_api)

1. Navigate to **Configuration > Search and metadata > Search API** (`/admin/config/search/search-api`)
2. Create a new server with "Dify Backend"
3. Configure credentials:
   - **Base URL**: Your Dify service URL
   - **API Key**: Your Dify API key
   - **Dataset ID**: Target dataset identifier
4. Create an index and add relevant content types
5. Configure fields (title, body, summary, etc.)

### 2. Official Widget (dify_widget_official)

1. Navigate to **Configuration > Search and metadata > Dify Iframe Widget** (`/admin/config/search/dify-widget-iframe`)
2. Configure:
   - **Base URL**: Your Dify service URL
   - **Token**: Your chatbot token
   - **Authentication**: Enable/disable authentication requirement

### 3. Vanilla Widget (dify_widget_vanilla)

1. Navigate to **Configuration > Search and metadata > Dify Vanilla Widget** (`/admin/config/search/dify-widget-vanilla`)
2. Create widget configurations with:
   - **Base URL**: Your Dify service URL
   - **API Token**: Your API token
   - **Token**: Your chatbot token
3. Add "Dify Chat Widget" blocks to desired regions

## Usage Examples

### Content Indexing
Once configured, the Search API backend automatically indexes your content to Dify when:
- New content is created
- Existing content is updated
- Manual reindexing is triggered

### Chatbot Integration
- **Official Widget**: Automatically appears on all pages for authenticated users
- **Vanilla Widget**: Appears where blocks are placed, with customizable appearance
- **Source Linking**: Chatbot responses include links back to original Drupal content

## Security Considerations

- **Credential Storage**: All API keys and tokens are stored in Drupal's state system and never exported with configuration
- **Authentication Control**: Both widgets can be restricted to authenticated users only
- **Data Privacy**: Content indexing respects Drupal's access control system
- **HTTPS Recommended**: Use HTTPS for all Dify service communications

## Requirements

- **Drupal**: 9.x, 10.x, or 11.x
- **PHP**: 8.1 or higher
- **Required Modules**:
  - Search API (for dify_search_api submodule)
- **External Dependencies**:
  - league/commonmark (automatically installed via Composer)

## Support and Documentation

For detailed configuration and troubleshooting, refer to the individual submodule README files:
- `modules/dify_search_api/README.md`
- `modules/dify_widget_official/README.md`
- `modules/dify_widget_vanilla/README.md`

Official Dify integration - Authorized by LangGenius, Inc. with written permission to use Dify name, branding, and assets for this Drupal module.
