<?php

namespace Drupal\dify_augmented_search\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\dify_augmented_search\Service\MarkdownService;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class MarkdownController extends ControllerBase {

  protected MarkdownService $markdownService;

  public function __construct(MarkdownService $markdown_service) {
    $this->markdownService = $markdown_service;
  }

  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('dify_augmented_search.markdown_service')
    );
  }

  public function render(Request $request): JsonResponse {
    $data = json_decode($request->getContent(), TRUE);
    $markdown = $data['markdown'] ?? '';
    $is_complete = $data['is_complete'] ?? false;

    if (empty($markdown)) {
      return new JsonResponse(['html' => '']);
    }

    try {
      $html = $this->markdownService->toHtmlStreaming($markdown, $is_complete);
      return new JsonResponse(['html' => $html]);
    }
    catch (\Exception $e) {
      $this->getLogger('dify_augmented_search')->error('Markdown rendering error: @error', ['@error' => $e->getMessage()]);
      return new JsonResponse(['html' => htmlspecialchars($markdown, ENT_QUOTES | ENT_HTML5, 'UTF-8')]);
    }
  }

}
