<?php

namespace Drupal\dify_search_api\Traits;

/**
 * Provides a trait for converting a PHP array to a CSV file.
 */
trait ArrayToCsvTrait {

  /**
   * Converts a PHP array to a CSV file.
   *
   * @param array $array
   *   The array to be converted (single row of data).
   * @param string $file_path
   *   The path to the CSV file to be created.
   *
   * @return bool
   *   TRUE if the CSV file was created successfully, FALSE otherwise.
   */
  public function arrayToCsv(array $array, string $file_path): bool {
    $file = fopen($file_path, 'wb');

    if ($file === FALSE) {
      throw new \RuntimeException("Unable to open file for writing: $file_path");
    }

    // Write header and data row.
    if (!empty($array)) {
      fputcsv($file, array_keys($array));
      fputcsv($file, $array);
    }

    return fclose($file);
  }

}
