# Dify Augmented Search

AI-powered search enhancement for Drupal using Dify API. This module provides a configurable block that detects search queries and displays intelligent AI responses.

## Features

- **Smart Detection**: Automatically detects Search API queries
- **AI Responses**: Gets contextual responses from Dify
- **Flexible Placement**: Standard Drupal block - place anywhere
- **Configuration**: Multiple Dify configurations support
- **Clean UI**: Minimal, responsive design

## How It Works

1. User performs a search on your site
2. Block detects the search query from URL parameters
3. Sends query to Dify API for AI response
4. Displays the response alongside search results
5. Hides automatically if no search or no response

## Installation

Enable the module via Drush:
```bash
drush pm-enable dify_augmented_search
```

Or through the Drupal admin interface at **Extend** (`/admin/modules`).

## Configuration

### 1. Place and Configure the Block

1. Go to **Structure > Block Layout** (`/admin/structure/block`)
2. Click "Place block" in desired region
3. Find "Dify Augmented Search" and configure:
   - **Dify Base URL**: Your Dify service URL
   - **API Token**: Your Dify chat API token
4. Save the block

Each block instance has its own independent configuration stored securely in Drupal State.

## Usage

The block automatically appears when:
- A search query is detected in the URL
- The Dify API returns a valid response
- The block is placed in a visible region

Common search parameters detected:
- `?search=query`
- `?keys=query`
- `?query=query`
- `?q=query`
- `?keyword=query`

## Dependencies

- **Parent Module**: `dify:dify`
- **Search API**: `search_api:search_api`
- **Drupal Core**: 9.x, 10.x, or 11.x

## Technical Details

### Service
- `DifyAugmentedSearchService`: Handles query detection and API calls

### Block Plugin
- `AugmentedSearchBlock`: Configurable block with independent Dify configuration

### Template
- `dify-augmented-search-block.html.twig`: Customizable output template

### Configuration Storage
Each block stores its configuration independently in Drupal State:
- `dify_augmented_search.block_{uuid}.base_url`
- `dify_augmented_search.block_{uuid}.token`

## Troubleshooting

**Block not showing:**
- Check if search parameters are in URL
- Verify block configuration (Base URL and Token)
- Check block placement and visibility settings

**No AI response:**
- Verify API token and base URL in block configuration
- Check Drupal logs for API errors
- Ensure Dify service is accessible

## Customization

### Template Override
Copy `templates/dify-augmented-search-block.html.twig` to your theme and modify.

### CSS Styling
Override styles in `css/dify-augmented-search.css` or add custom CSS to your theme.

### Search Detection
Extend `DifyAugmentedSearchService::detectSearchQuery()` for custom search parameter detection.
