# Dify Widget Official

Official Dify chatbot widget integration for Drupal using Dify's embed script. This submodule provides seamless integration with the official Dify widget, automatically embedding it site-wide for authenticated users.

## Features

- **Official Dify Widget**: Uses Dify's official embed.min.js script
- **Site-wide Integration**: Automatically appears on all pages
- **Authentication Control**: Restrict access to authenticated users only
- **Minimal Configuration**: Simple setup with just base URL and token
- **Automatic Loading**: No manual block placement required
- **Secure Credentials**: Tokens stored securely in Drupal state

## How It Works

This module integrates the official Dify chatbot widget by:
1. Loading Dify's embed.min.js script from your Dify service
2. Configuring the widget with your chatbot token
3. Automatically displaying the widget on all pages (when enabled)
4. Respecting authentication requirements

## Installation

The module is automatically available when the parent Dify module is installed. Enable it via:

```bash
drush pm-enable dify_widget_official
```

Or through the Drupal admin interface at **Extend** (`/admin/modules`).

## Configuration

### Basic Setup

1. Navigate to **Configuration > Search and metadata > Dify Iframe Widget** (`/admin/config/search/dify-widget-iframe`)

2. Configure the following settings:
   - **Enable iframe widget site-wide**: Check to activate the widget
   - **Base URL**: Your Dify service URL (e.g., `https://dify.ai`)
   - **Iframe Token**: Your Dify chatbot token

3. Save the configuration

### Authentication Settings

By default, the widget only appears for authenticated users. This behavior is controlled by the `authenticated_only` setting in the configuration.

### Page Exclusions

The configuration form includes options for excluding the widget from specific pages (feature may be expanded in future versions).

## Usage

Once configured and enabled, the official Dify widget will:

- Automatically appear on all pages for authenticated users
- Load the official Dify embed script from your configured base URL
- Display as a floating widget (typically in the bottom-right corner)
- Provide the standard Dify chatbot interface and functionality

## Technical Implementation

### Hook Implementation

The module uses `hook_page_attachments()` to:
- Check if the widget is properly configured
- Verify user authentication (if required)
- Attach the Dify library and configuration
- Load the embed script from the configured Dify service

### JavaScript Configuration

The module creates a global `window.difyChatbotConfig` object with:
- `token`: Your chatbot token
- `baseUrl`: Your Dify service URL
- `systemVariables`: Additional configuration (currently empty)

### Security Features

- **State Storage**: All credentials are stored in Drupal's state system
- **Authentication Check**: Respects authentication requirements
- **URL Validation**: Validates base URL format
- **Token Validation**: Ensures token contains only valid characters

## Differences from Vanilla Widget

| Feature | Official Widget | Vanilla Widget |
|---------|----------------|----------------|
| **Source** | Dify's embed.min.js | Custom implementation |
| **Placement** | Automatic site-wide | Block-based placement |
| **Customization** | Limited to Dify's options | Extensive customization |
| **Features** | Standard Dify features | Enhanced features (themes, history, etc.) |
| **Configuration** | Simple token-based | Multiple configurations supported |
| **Updates** | Automatic via Dify | Manual module updates |

## Troubleshooting

### Widget Not Appearing

1. **Check Configuration**: Ensure base URL and token are properly set
2. **Verify Authentication**: Confirm user is logged in (if authentication required)
3. **Check Browser Console**: Look for JavaScript errors
4. **Validate URLs**: Ensure base URL is accessible and returns valid responses

### Configuration Issues

1. **Token Format**: Ensure token contains only letters, numbers, hyphens, and underscores
2. **URL Format**: Base URL must be a valid URL format
3. **Service Availability**: Verify your Dify service is accessible

### Performance Considerations

- The embed script is loaded with `defer` attribute for optimal performance
- Widget only loads when configuration is complete and valid
- Authentication checks are performed server-side to avoid unnecessary loading

## Dependencies

- **Parent Module**: `dify:dify` (main Dify module)
- **Drupal Core**: Compatible with Drupal 9, 10, and 11
- **External Service**: Requires access to your Dify service URL

## Security Considerations

- **HTTPS Recommended**: Use HTTPS URLs for your Dify service
- **Token Security**: Tokens are stored securely and never exported with configuration
- **Authentication Control**: Widget respects Drupal's authentication system
- **Cross-Origin**: Ensure your Dify service allows embedding from your domain

## API Reference

### Configuration Service

The module uses the shared `dify.configuration_service` with namespace `widget_official`:

```php
$config = \Drupal::service('dify.configuration_service')
  ->getConfiguration('widget_official', 'default');
```

### Configuration Structure

```php
[
  'token' => 'your-chatbot-token',
  'base_url' => 'https://your-dify-service.com',
  'authenticated_only' => TRUE,
]
```

## Support

For issues specific to the official widget integration, check:
1. This module's configuration
2. Your Dify service status
3. Browser developer tools for JavaScript errors
4. Drupal logs for PHP errors

For Dify platform issues, consult the official Dify documentation.
