# Dify Widget Vanilla

A custom-built floating chatbot widget with direct Dify API integration for Drupal. This submodule provides an advanced, highly customizable chatbot interface with enhanced features beyond the standard Dify widget.

## Features

### Core Functionality
- **Floating Widget**: Elegant floating interface with smooth open/close animations
- **Real-time Streaming**: Live streaming responses from Dify API
- **Conversation History**: Persistent conversation storage per user
- **Message Suggestions**: Interactive message suggestions for better UX
- **Resizable Interface**: User-adjustable widget size
- **Unread Notifications**: Visual indicators for new messages when widget is closed

### Customization
- **Markdown Rendering**: Full markdown support with syntax highlighting
- **Theme Support**: Dark and light theme options
- **Color Customization**: Extensive color customization system with CSS variables
- **Block-based Placement**: Flexible placement using Drupal's block system
- **Multiple Configurations**: Support for multiple widget configurations

### Advanced Features
- **User Context**: Automatic user identification and context
- **Error Handling**: Robust error handling with user-friendly messages
- **Performance Optimized**: Efficient JavaScript implementation
- **Accessibility**: ARIA labels and keyboard navigation support

## Installation

This submodule is automatically available when the parent Dify module is installed. Enable it via:

```bash
drush pm-enable dify_widget_vanilla
```

Or through the Drupal admin interface at **Extend** (`/admin/modules`).

## Configuration

### 1. Create Widget Configuration

1. Navigate to **Configuration > Search and metadata > Dify Vanilla Widget** (`/admin/config/search/dify-widget-vanilla`)
2. Click **Add New Configuration**
3. Configure the following settings:
   - **Configuration Name**: Unique identifier for this configuration
   - **Base URL**: Your Dify service URL
   - **API Token**: Your Dify API token for direct API calls
   - **Token**: Your Dify chatbot token

### 2. Add Widget Block

1. Navigate to **Structure > Block layout** (`/admin/structure/block`)
2. Click **Place block** in your desired region
3. Find and select **Dify Chat Widget**
4. Configure block settings:
   - **Widget Configuration**: Select your created configuration
   - **Widget Title**: Custom title for the widget
   - **Placeholder Text**: Custom placeholder for the input field
   - **Markdown Theme**: Choose between Dark or Light theme
   - **Color Customization**: Customize colors using the extensive color system

### 3. Color Customization

The widget supports extensive color customization through CSS variables:

#### Primary Colors
- Main accent color and hover states
- Primary action buttons and links

#### Background Colors
- Widget background, message area, input fields
- Secondary and tertiary backgrounds

#### Text Colors
- Primary, secondary, muted, and placeholder text
- Different text states and contexts

#### Message Colors
- User and bot message backgrounds
- Error message styling

#### Special States
- Notification badges, success, and warning colors

## Usage

### For Site Visitors
1. **Opening**: Click the floating widget button (usually bottom-right)
2. **Chatting**: Type messages in the input field
3. **Suggestions**: Click on suggested messages for quick responses
4. **History**: Previous conversations are automatically saved
5. **Resizing**: Drag the resize handle to adjust widget size
6. **Closing**: Click the close button or outside the widget

### For Administrators
- **Multiple Widgets**: Create different configurations for different purposes
- **Block Placement**: Place widgets in different regions or pages
- **Theme Matching**: Customize colors to match your site theme
- **User Targeting**: Use block visibility settings to target specific users

## Technical Implementation

### Architecture
- **JavaScript Class**: Modern ES6 class-based implementation
- **Drupal Integration**: Full integration with Drupal behaviors and settings
- **API Communication**: Direct communication with Dify API endpoints
- **State Management**: Local storage for conversation persistence

### Files Structure
- `js/dify-widget.js` - Main widget functionality and API integration
- `css/dify-widget.css` - Core widget styling
- `css/dify-widget-variables.css` - CSS variables for customization
- `css/github-markdown-dark.css` - Dark theme markdown styling
- `css/github-markdown-light.css` - Light theme markdown styling
- `templates/dify-widget-vanilla.html.twig` - Widget HTML template

### JavaScript API
The widget exposes several methods for advanced customization:

```javascript
// Access widget instance
const widget = Drupal.difyWidgetVanilla.instances[widgetId];

// Send programmatic message
widget.sendMessage('Hello from code');

// Clear conversation
widget.clearConversation();

// Toggle widget
widget.toggle();
```

## Differences from Official Widget

| Feature | Vanilla Widget | Official Widget |
|---------|----------------|-----------------|
| **Implementation** | Custom JavaScript | Dify's embed.min.js |
| **Customization** | Extensive color/theme options | Limited to Dify's options |
| **Placement** | Block-based, flexible | Automatic site-wide |
| **Features** | Enhanced (history, themes, etc.) | Standard Dify features |
| **Configuration** | Multiple configurations | Single configuration |
| **Performance** | Optimized for Drupal | Standard Dify performance |
| **Updates** | Module updates | Automatic via Dify |

## Troubleshooting

### Widget Not Appearing
1. **Check Block Placement**: Ensure block is placed in a visible region
2. **Verify Configuration**: Check that configuration exists and is complete
3. **Check Permissions**: Verify user has access to view the block
4. **JavaScript Errors**: Check browser console for errors

### API Connection Issues
1. **Credentials**: Verify API token and base URL are correct
2. **CORS**: Ensure Dify service allows requests from your domain
3. **Network**: Check network connectivity to Dify service
4. **SSL**: Use HTTPS for both Drupal and Dify service

### Styling Issues
1. **Theme Conflicts**: Check for CSS conflicts with your theme
2. **Color Variables**: Verify CSS variables are properly applied
3. **Z-index**: Ensure widget appears above other elements
4. **Responsive**: Test on different screen sizes

## Performance Considerations

- **Lazy Loading**: Widget JavaScript loads only when needed
- **Conversation Storage**: Uses efficient local storage for history
- **API Optimization**: Implements proper request throttling
- **Memory Management**: Proper cleanup of event listeners and timers

## Security Considerations

- **Token Security**: API tokens stored securely in Drupal state
- **User Context**: Respects Drupal's user authentication
- **XSS Protection**: Proper sanitization of user input and bot responses
- **CORS**: Requires proper CORS configuration on Dify service

## Dependencies

- **Parent Module**: `dify:dify` (main Dify module)
- **Drupal Core**: Compatible with Drupal 9, 10, and 11
- **External Service**: Requires access to Dify API endpoints

## Browser Compatibility

- **Modern Browsers**: Chrome 60+, Firefox 55+, Safari 12+, Edge 79+
- **CSS Variables**: Requires CSS Custom Properties support
- **ES6 Features**: Uses modern JavaScript features
- **Local Storage**: Requires Web Storage API support

## Credits

This module includes `github-markdown-dark.css` and `github-markdown-light.css` from [github-markdown-css](https://github.com/sindresorhus/github-markdown-css) by Sindre Sorhus, licensed under the MIT License.

Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (https://sindresorhus.com)

## Contributing

When contributing to this submodule:
1. Follow Drupal coding standards
2. Test across different browsers and devices
3. Ensure accessibility compliance
4. Update documentation for new features
5. Consider performance impact of changes
