# Disable Account Emails

Allows site administrators to selectively disable specific user account emails sent by Drupal core's user module.

## Description

The Disable Account Emails module provides a simple interface for administrators to control which automated account-related emails are sent to users. This is useful for sites that:

- Use external authentication systems (LDAP, SSO, OAuth, etc.)
- Handle user communications through custom workflows
- Want to prevent specific emails while keeping others enabled
- Need fine-grained control over user email notifications

## Features

- **Simple checkbox interface** - Integrated directly into Drupal's Account Settings page
- **Selective control** - Disable only the emails you want, keep others enabled
- **9 email types supported**:
  - Welcome (new user created by admin)
  - Welcome (awaiting approval)
  - Admin notification (user awaiting approval)
  - Welcome (no approval required)
  - Account activation
  - Account blocked
  - Account cancellation confirmation
  - Account cancelled
  - Password recovery
- **No separate configuration page** - Settings appear where you'd expect them
- **Comprehensive test coverage** - Functional, Kernel, and Unit tests included
- **Drupal 11 ready** - Built with modern Drupal coding standards

## Requirements

- Drupal: ^11
- PHP: 8.1 or higher

## Installation

Install as you would normally install a contributed Drupal module. Visit
https://www.drupal.org/docs/extending-drupal/installing-modules for further information.

### Using Composer (recommended)

```bash
composer require drupal/disable_account_emails
```

### Manual Installation

1. Download the module
2. Extract to your `modules/contrib` directory
3. Enable the module

### Using Drush

```bash
drush en disable_account_emails
```

## Configuration

1. Navigate to **Administration > Configuration > People > Account settings**
   (`/admin/config/people/accounts`)
2. Scroll to the **"Disable Account Emails"** section at the bottom
3. Check the boxes for emails you want to **disable**
4. Click **"Save configuration"**

**Note**: Checked boxes mean those emails will NOT be sent.

## How It Works

The module uses Drupal's `hook_mail_alter()` to intercept outgoing emails from the user module. When an email type is configured to be disabled, the module sets `$message['send'] = FALSE`, preventing the email from being sent.

The configuration form is integrated directly into the existing Account Settings page using `hook_form_FORM_ID_alter()`, making it easy to find and manage alongside other user-related settings.

## Use Cases

### Example 1: External Authentication
If your site uses LDAP or SSO for authentication, you may want to disable password-related emails:
- ✓ Disable "Password recovery"
- ✓ Disable "Account activation"

### Example 2: Custom Registration Workflow
If you handle user registration through a custom process:
- ✓ Disable "Welcome (no approval required)"
- ✓ Keep admin notifications enabled

### Example 3: Prevent All Account Emails
For sites that handle all user communication externally:
- ✓ Disable all 9 email types

## Testing

The module includes comprehensive automated tests:

### Run All Tests
```bash
php core/scripts/run-tests.sh --verbose --color --module disable_account_emails
```

### Run Specific Test Groups
```bash
# Functional tests only
php core/scripts/run-tests.sh --verbose --class "Drupal\Tests\disable_account_emails\Functional\DisableAccountEmailsTest"

# Kernel tests only
php core/scripts/run-tests.sh --verbose --class "Drupal\Tests\disable_account_emails\Kernel\ConfigSchemaTest"

# Unit tests only
php core/scripts/run-tests.sh --verbose --class "Drupal\Tests\disable_account_emails\Unit\EmailTypesTest"
```

### Using PHPUnit
```bash
vendor/bin/phpunit modules/contrib/disable_account_emails
```

## Uninstallation

When you uninstall the module, all configuration is automatically removed. No cleanup is required.

## Troubleshooting

### Emails are still being sent
1. Clear all caches: `drush cr`
2. Verify the checkbox is checked on the configuration page
3. Check that the email key matches one of the supported types
4. Review your site's mail system configuration

### Configuration not saving
1. Ensure you have the "Administer account settings" permission
2. Check for PHP errors in your logs
3. Verify file permissions on your configuration directory

### Module conflicts
This module only affects emails sent by Drupal's core user module. It does not interfere with:
- Custom modules sending their own emails
- Contrib modules with separate email systems
- Emails from other core modules (contact, node, etc.)

## Development

### Coding Standards
This module follows Drupal coding standards. To check:

```bash
phpcs --standard=Drupal,DrupalPractice modules/contrib/disable_account_emails/
```

### Static Analysis
```bash
phpstan analyse modules/contrib/disable_account_emails/
```

## Support

- **Issue Queue**: https://www.drupal.org/project/issues/disable_account_emails
- **Documentation**: https://www.drupal.org/docs/contributed-modules/disable-account-emails

## Maintainers

Current maintainers:
- Your Name - https://www.drupal.org/u/chris-matthews

## License

This project is GPL-2.0+ licensed.

## Related Modules

- **[Disable User](https://www.drupal.org/project/disable_user)** - Provides additional user management features
- **[Override Node Options](https://www.drupal.org/project/override_node_options)** - Similar permission-based overrides for content
- **[Disable Messages](https://www.drupal.org/project/disable_messages)** - Control system messages shown to users

## Changelog

### 1.0.0 (2026-01-09)
- Initial release
- Support for all 9 core user account email types
- Integration with Account Settings page
- Comprehensive test coverage
- Drupal 11 compatibility
```

This README includes:
- Clear description and features
- Installation instructions (multiple methods)
- Configuration steps with screenshots guidance
- Use case examples
- Testing instructions
- Troubleshooting section
- Development guidelines
- Support information

Feel free to customize it with your actual Drupal.org username and any other specific details!