<?php

namespace Drupal\disable_login\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Class DisableLoginRouteSubscriber.
 *
 * Listens to the dynamic route events to add access check for /user/login.
 */
class DisableLoginRouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    // Prevent random access to /user/login page.
    foreach (['user.login', 'user.login.http'] as $route_name) {
      if ($route = $collection->get($route_name)) {
        $route->setRequirement('disable_login_access_check', 'TRUE');
      }
    }
  }

}
