## Introduction

This module prevents users from logging in on certain domain names.

## Example use case

Here's an example use case. Imagine that you use a CDN for public traffic to
your Drupal site, at URL https://www.example.com. Public traffic users are not
supposed to log into Drupal; only your internal staff can log in (e.g., to edit
pages).

Your staff uses the "origin" URL to log into Drupal, at
https://manage.example.com. This URL is only available behind a VPN.

For this reason, no one should be allowed to log into Drupal on the public/CDN
domain name. They shouldn't even be allowed to try to log in.

This module helps to achieve that goal. It blocks the user login forms when they
are accessed on the public domain name.

## Installation and configuration

1. Install like any other module
1. Manage the settings at `/admin/config/people/disable-login-by-domain`

## Features

These are the ways this module prevents user login attempts:

1. Disables the _User login_ block
    - Prevents access to this block in `disable_login_by_domain_block_access()`.
    - If this block is placed by Layout Builder, then it gets disabled by
      `\Drupal\disable_login_by_domain\EventSubscriber\DisableUserLoginBlock`.
1. Disables the user login form itself
    - If someone embeds the user login form into a custom block, this module
      will remove essential elements from the form, rendering it useless.
    - See `disable_login_by_domain_form_user_login_form_alter()`.
1. Disables the login page (`/user/login`).
    - See `\Drupal\disable_login_by_domain\Access\PageAccessCheck`
1. Immediately logs out a user if that user somehow finds a way to log in.
    - See `disable_login_by_domain_user_login()`

