<?php

namespace Drupal\disable_login_by_domain\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides settings form for disable_login_by_domain.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'disable_login_by_domain_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['disable_login_by_domain.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('disable_login_by_domain.settings');
    $domains_list = $config->get('domains');

    $form['domains'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Domains'),
      '#description' => $this->t('Enter each disallowed domain on a new line. Users will not be allowed to log in if the site is using one of these domains.'),
      '#default_value' => implode("\n", $domains_list),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $domains_str = $form_state->getValue('domains');
    $domains_list = array_map('trim', explode("\n", $domains_str));

    $this->config('disable_login_by_domain.settings')
      ->set('domains', $domains_list)
      ->save();

    parent::submitForm($form, $form_state);
  }

}
