<?php

namespace Drupal\disable_user_deletion\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class for settings form.
 */
final class SettingsForm extends ConfigFormBase {

  /**
   * The module settings.
   */
  const MODULE_SETTINGS = 'disable_user_deletion.settings';

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      static::MODULE_SETTINGS,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return static::MODULE_SETTINGS;
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config(static::MODULE_SETTINGS);

    $form['disable_deletion'] = [
      '#type' => 'container',
    ];
    $form['disable_deletion']['title'] = [
      '#type' => 'html_tag',
      '#tag' => 'h4',
      '#value' => $this->t('Disabling user deletion actions'),
    ];
    $form['disable_deletion']['description'] = [
      '#type' => 'html_tag',
      '#tag' => 'p',
      '#value' => $this->t('Select the user deletion actions you would like to disable.'),
    ];

    $form['disable_deletion']['user_cancel_reassign'] = [
      '#type' => 'checkbox',
      '#title' => $this->t("Delete the account and make its content belong to the Anonymous user"),
      '#default_value' => $config->get('user_cancel_reassign') ?? FALSE,
    ];

    $form['insight_switch']['user_cancel_delete'] = [
      '#type' => 'checkbox',
      '#title' => $this->t("Delete the account and its content."),
      '#default_value' => $config->get('user_cancel_delete') ?? FALSE,
    ];

    $form['disable_deletion']['user_cancel_block_unpublish'] = [
      '#type' => 'checkbox',
      '#title' => $this->t("Disable the account and unpublish its content."),
      '#default_value' => $config->get('user_cancel_block_unpublish') ?? FALSE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
    $config_object = $this->config(static::MODULE_SETTINGS);
    $config_object->set('user_cancel_reassign', $form_state->getValue('user_cancel_reassign'));
    $config_object->set('user_cancel_delete', $form_state->getValue('user_cancel_delete'));
    $config_object->set('user_cancel_block_unpublish', $form_state->getValue('user_cancel_block_unpublish'));
    $config_object->save();
  }

}
