<?php

namespace Drupal\discourse_comments_plus\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;

/**
 * Plugin implementation of the 'comment_count_plus_formatter' formatter.
 *
 * @FieldFormatter(
 *   id = "comment_count_plus_formatter",
 *   label = @Translation("Comment count plus formatter"),
 *   field_types = {
 *     "discourse_plus_field"
 *   }
 * )
 */
class CommentCountFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];

    foreach ($items as $delta => $item) {
      $elements[$delta] = ['#markup' => $item->comment_count];
    }

    return $elements;
  }

}
