# Display Builder documentation

!!! warning "Development stage"

    The module is still in heavy development and is **not intended for Production** yet!
    Follow us on slack [#display_builder](https://drupal.slack.com/archives/C092EUNPCRW)</h2>

A display building tool by the [UI Suite](https://www.drupal.org/project/ui_suite) team:

- **Design system native**: fully use your design system (components, style utilities, icons, themes/modes, CSS variables...) directly in Drupal without the burden of compatibility layers
- **Unified**: can be used instead of Layout Builder for entity view displays, Block Layout for page displays, and as a replacement of the Views' display building feature
- **Modern**: A builder for the world of today, with powerful features (dynamic previews, pattern presets, real-time collaboration, deep integration with Drupal APIs...)

Display Builder provides sub-modules for each Drupal Core's display building need:

- [Entity view](entity-displays.md) and [entity view overrides](entity-displays-overrides.md) (`display_builder_entity_view`)
- [Page layout](page-layout.md) (`display_builder_page_layout`)
- [Views](with-views.md) (`display_builder_views`)

## Maintainers

Current maintainers:

- Jean Valverde - [mogtofu33](https://www.drupal.org/u/mogtofu33)
- Mikael Meulle - [just_like_good_vibes](https://www.drupal.org/u/just_like_good_vibes)
- Pierre Dureau - [pdureau](https://www.drupal.org/u/pdureau)

Supporting organizations:

- [Beyris](https://www.drupal.org/beyris) - We are leading impactful open-source
  projects and we are providing coding, training, audit and consulting.
