<?php

declare(strict_types=1);

namespace Drupal\display_builder\Plugin\display_builder\Island;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\display_builder\Attribute\Island;
use Drupal\display_builder\InstanceInterface;
use Drupal\display_builder\IslandPluginBase;
use Drupal\display_builder\IslandType;

/**
 * Menu island plugin implementation.
 */
#[Island(
  id: 'menu',
  label: new TranslatableMarkup('Main menu items'),
  description: new TranslatableMarkup('Copy, paste and duplicate.'),
  type: IslandType::Menu,
)]
class Menu extends IslandPluginBase {

  /**
   * {@inheritdoc}
   */
  public function build(InstanceInterface $builder, array $data = [], array $options = []): array {
    $builder_id = (string) $builder->id();
    // Attribute data-contextual-menu is important for the js mapping.
    // @see assets/js/contextual_menu.js
    // Urls are generated with placeholders to be replaced in the js.
    $duplicate = $this->buildMenuItem($this->t('Duplicate'), 'duplicate');
    $duplicate = $this->htmxEvents->onClickDuplicate($duplicate, $builder_id, '__node_id__', '__parent_id__', '__slot_id__', '__slot_position__');

    $paste = $this->buildMenuItem($this->t('Paste'), 'paste');
    $paste = $this->htmxEvents->onClickPaste($paste, $builder_id, '__node_id__', '__parent_id__', '__slot_id__', '__slot_position__');

    return [
      $this->buildMenuItem($this->t('Copy'), 'copy'),
      $paste,
      $duplicate,
    ];
  }

}
