<?php

declare(strict_types=1);

namespace Drupal\display_builder_dev_tools\Form;

use Drupal\Core\DependencyInjection\AutowireTrait;
use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Defines a confirmation form to confirm deletion of all display builder.
 */
class ConfirmDeleteAllForm extends ConfirmFormBase {

  use AutowireTrait;

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return new Url('entity.display_builder_instance.collection');
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'confirm_display_builder_delete_all_form';
  }

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Do you want to delete all display builder instance(s) created?');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $storage = \Drupal::service('entity_type.manager')->getStorage('display_builder_instance');
    $instances = $storage->loadMultiple();
    $storage->delete($instances);
    $form_state->setRedirectUrl(new Url('entity.display_builder_instance.collection'));
    \Drupal::service('plugin.cache_clearer')->clearCachedDefinitions();
  }

}
