<?php

declare(strict_types=1);

namespace Drupal\display_builder_dev_tools\Plugin\display_builder\Island;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\display_builder\Attribute\Island;
use Drupal\display_builder\InstanceInterface;
use Drupal\display_builder\IslandPluginBase;
use Drupal\display_builder\IslandType;
use Drupal\display_builder\RenderableBuilderTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * State buttons island plugin implementation.
 */
#[Island(
  id: 'operation',
  label: new TranslatableMarkup('Operations'),
  description: new TranslatableMarkup('[Debug] Provide some direct operations links.'),
  type: IslandType::Button,
)]
class OperationButton extends IslandPluginBase {

  use RenderableBuilderTrait;

  /**
   * The module handler.
   *
   * @var \Drupal\Core\Extension\ModuleHandlerInterface
   */
  protected $moduleHandler;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->moduleHandler = $container->get('module_handler');

    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function build(InstanceInterface $builder, array $data = [], array $options = []): array {
    $button = $this->buildButton('', 'operations', 'link-45deg');
    $button['#props']['variant'] = 'neutral';
    $button['#attributes']['outline'] = TRUE;

    $list = $this->entityTypeManager->getListBuilder('display_builder_profile');
    $items = $list->getOperations($builder);

    if (empty($items)) {
      return [];
    }

    return [
      '#type' => 'component',
      '#component' => 'display_builder:dropdown',
      '#props' => [
        'placement' => 'bottom',
      ],
      '#slots' => [
        'button' => $button,
        'content' => [
          '#type' => 'component',
          '#component' => 'display_builder:menu',
          '#props' => [
            'items' => $items,
          ],
          '#attributes' => [
            'class' => ['db-background'],
          ],
        ],
      ],
    ];
  }

}
