<?php

declare(strict_types=1);

namespace Drupal\display_builder_dev_tools\Plugin\display_builder\Island;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\display_builder\Attribute\Island;
use Drupal\display_builder\InstanceInterface;
use Drupal\display_builder\IslandPluginBase;
use Drupal\display_builder\IslandType;
use Drupal\display_builder_dev_tools\Form\ImportForm;

/**
 * Test island plugin for testing purposes.
 */
#[Island(
  id: 'reset_button',
  label: new TranslatableMarkup('Reset'),
  description: new TranslatableMarkup('[Debug] Reset the content on the builder with a fixture or manual sources.'),
  type: IslandType::Button,
)]
class ResetButton extends IslandPluginBase {

  /**
   * {@inheritdoc}
   */
  public function build(InstanceInterface $builder, array $data = [], array $options = []): array {
    $builder_id = (string) $builder->id();
    $form = \Drupal::formBuilder()->getForm(
      ImportForm::class,
      $builder_id,
    );

    unset($form['cancel']);

    $button = $this->buildButton('', 'dev_reset', 'gear');

    $button['#props']['variant'] = 'warning';
    $button['#attributes']['outline'] = TRUE;

    $build = [
      '#type' => 'component',
      '#component' => 'display_builder:dropdown',
      '#props' => [
        'placement' => 'bottom',
      ],
      '#slots' => [
        'button' => $button,
        'content' => [
          '#type' => 'html_tag',
          '#tag' => 'div',
          '#attributes' => [
            'class' => ['db-background', 'db-devel-reset'],
          ],
          'content' => $form,
        ],
      ],
      '#attached' => [
        'library' => ['display_builder_dev_tools/reset'],
      ],
    ];

    return $build;
  }

  /**
   * {@inheritdoc}
   */
  public function onActive(string $builder_id, array $data): array {
    return $this->reloadWithLocalData($builder_id, $data);
  }

}
