# Display Builder Dev Tools

Some Dev Tools for [Display Builder](https://www.drupal.org/project/display_builder).

Display Builder is a display building tool by the [UI Suite](https://www.drupal.org/project/ui_suite) team:

- **Design system native**: fully use your design system (components, style utilities, icons, themes/modes, CSS variables...) directly in Drupal without the burden of compatibility layers
- **Unified**: can be used instead of Layout Builder for entity view displays, Block Layout for page displays, and as a replacement of the Views' display building feature.
- **Modern**: A builder for the world of today, with powerful features (dynamic previews, pattern presets, real-time collaboration, deep integration with Drupal APIs...)

## Installation

Install as you would normally install a contributed Drupal module.
See: [Installing Modules](https://www.drupal.org/docs/extending-drupal/installing-modules) for further information.

!!! warning "Dev Tools"
  The module is a development tools and must not be used in production.

## Contributing

Join us on slack [#display_builder](https://drupal.slack.com/archives/C092EUNPCRW).

See [documentation](./docs/contributing.md).

## Maintainers

Current maintainers:

- Jean Valverde - [mogtofu33](https://www.drupal.org/u/mogtofu33)

Supporting organizations:

- [Beyris](https://www.drupal.org/beyris) - We are leading impactful open-source
  projects and we are providing coding, training, audit and consulting.
- You want to support us? Contact us on slack [#display_builder](https://drupal.slack.com/archives/C092EUNPCRW)
