# Drupal Idle Timer

A Drupal module that automatically logs out users after a period of inactivity and tracks these logout events.

## Features

- Automatically log out users after a configurable period of inactivity
- Display a warning modal before automatic logout
- Countdown timer showing remaining time before logout
- Track and log all idle logout events
- Administrative reports for reviewing idle logout activity
- Filter reports by username and date range
- Support for multiple sync methods (AJAX, localStorage, sessionStorage)

## Installation

1. Enable the module
2. Configure the idle timer settings at `/admin/content/drupal-idle-timer/settings`
3. Grant the "Access Idle Timer Reports" permission to roles that should view logout logs

## Configuration

Navigate to `/admin/content/drupal-idle-timer/settings` to configure:

- Timeout duration
- Warning duration
- Sync method (AJAX, localStorage, sessionStorage)
- Allowed roles
- Modal settings
- Log retention period (days)
- Debug mode

## Reports

Site administrators can view idle logout reports at `/admin/reports/drupal-idle-timer`.

The reports include:
- User who was logged out
- Logout timestamp
- IP address
- User agent information

Reports can be filtered by:
- Username (partial match)
- Date range (from/to)

## Permissions

- **Access Idle Timer Reports**: Allows users to view the idle logout reports page

## Database Schema

The module creates a `drupal_idle_timer_logs` table to store:
- User ID and username
- Logout timestamp
- IP address
- User agent string

## Technical Details

- Logs are created when users are automatically logged out due to inactivity
- The module uses dependency injection for all services
- Pagination is enabled on the reports page (50 records per page)
- The database table includes indexes on `uid` and `logout_time` for performance

## Log Retention & Maintenance

### Automatic Cleanup

The module automatically cleans up old logs during cron runs based on the configured retention period:

1. Go to `/admin/content/drupal-idle-timer/settings`
2. Set the "Log retention (days)" value (default: 90 days)
3. Set to 0 to keep logs indefinitely
4. Logs older than the retention period are automatically deleted during cron runs

### Manual Cleanup

To manually clear old logs, you can run a database query:

```sql
DELETE FROM drupal_idle_timer_logs WHERE logout_time < UNIX_TIMESTAMP('YYYY-MM-DD');
```

Or use Drush to trigger a cron run:

```bash
drush cron
```
